/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

public class MetricValue
implements JsonSerializable<MetricValue> {
    private Integer count;
    private Double average;
    private Double maximum;
    private Double minimum;
    private OffsetDateTime timestamp;
    private Double total;

    public Integer count() {
        return this.count;
    }

    MetricValue withCount(Integer count) {
        this.count = count;
        return this;
    }

    public Double average() {
        return this.average;
    }

    MetricValue withAverage(Double average) {
        this.average = average;
        return this;
    }

    public Double maximum() {
        return this.maximum;
    }

    MetricValue withMaximum(Double maximum) {
        this.maximum = maximum;
        return this;
    }

    public Double minimum() {
        return this.minimum;
    }

    MetricValue withMinimum(Double minimum) {
        this.minimum = minimum;
        return this;
    }

    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    MetricValue withTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public Double total() {
        return this.total;
    }

    MetricValue withTotal(Double total) {
        this.total = total;
        return this;
    }

    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static MetricValue fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MetricValue deserializedMetricValue = new MetricValue();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("_count".equals(fieldName)) {
                    deserializedMetricValue.count = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("average".equals(fieldName)) {
                    deserializedMetricValue.average = reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("maximum".equals(fieldName)) {
                    deserializedMetricValue.maximum = reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("minimum".equals(fieldName)) {
                    deserializedMetricValue.minimum = reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("timestamp".equals(fieldName)) {
                    deserializedMetricValue.timestamp = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("total".equals(fieldName)) {
                    deserializedMetricValue.total = reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMetricValue;
        });
    }
}

