/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.EventHubsManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.fluent.ConsumerGroupsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.fluent.EventHubManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.fluent.models.ConsumerGroupInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.implementation.EventHubConsumerGroupImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.EventHubConsumerGroup;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.EventHubConsumerGroups;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.implementation.WrapperImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Objects;

public final class EventHubConsumerGroupsImpl
extends WrapperImpl<ConsumerGroupsClient>
implements EventHubConsumerGroups {
    private final EventHubsManager manager;

    public EventHubConsumerGroupsImpl(EventHubsManager manager) {
        super(((EventHubManagementClient)manager.serviceClient()).getConsumerGroups());
        this.manager = manager;
    }

    @Override
    public EventHubsManager manager() {
        return this.manager;
    }

    @Override
    public EventHubConsumerGroupImpl define(String name) {
        return new EventHubConsumerGroupImpl(name, this.manager);
    }

    @Override
    public EventHubConsumerGroup getById(String id) {
        return this.getByIdAsync(id).block();
    }

    @Override
    public Mono<EventHubConsumerGroup> getByIdAsync(String id) {
        Objects.requireNonNull(id);
        ResourceId resourceId = ResourceId.fromString(id);
        return this.getByNameAsync(resourceId.resourceGroupName(), resourceId.parent().parent().name(), resourceId.parent().name(), resourceId.name());
    }

    @Override
    public Mono<EventHubConsumerGroup> getByNameAsync(String resourceGroupName, String namespaceName, String eventHubName, String name) {
        return ((ConsumerGroupsClient)this.innerModel()).getAsync(resourceGroupName, namespaceName, eventHubName, name).map(this::wrapModel);
    }

    @Override
    public EventHubConsumerGroup getByName(String resourceGroupName, String namespaceName, String eventHubName, String name) {
        return this.getByNameAsync(resourceGroupName, namespaceName, eventHubName, name).block();
    }

    @Override
    public PagedIterable<EventHubConsumerGroup> listByEventHub(String resourceGroupName, String namespaceName, String eventHubName) {
        return PagedConverter.mapPage(((ConsumerGroupsClient)this.innerModel()).listByEventHub(resourceGroupName, namespaceName, eventHubName), this::wrapModel);
    }

    @Override
    public PagedFlux<EventHubConsumerGroup> listByEventHubAsync(String resourceGroupName, String namespaceName, String eventHubName) {
        return PagedConverter.mapPage(((ConsumerGroupsClient)this.innerModel()).listByEventHubAsync(resourceGroupName, namespaceName, eventHubName), this::wrapModel);
    }

    @Override
    public void deleteById(String id) {
        this.deleteByIdAsync(id).block();
    }

    @Override
    public Mono<Void> deleteByIdAsync(String id) {
        Objects.requireNonNull(id);
        ResourceId resourceId = ResourceId.fromString(id);
        return this.deleteByNameAsync(resourceId.resourceGroupName(), resourceId.parent().parent().name(), resourceId.parent().name(), resourceId.name());
    }

    @Override
    public Mono<Void> deleteByNameAsync(String resourceGroupName, String namespaceName, String eventHubName, String name) {
        return ((ConsumerGroupsClient)this.innerModel()).deleteAsync(resourceGroupName, namespaceName, eventHubName, name);
    }

    @Override
    public void deleteByName(String resourceGroupName, String namespaceName, String eventHubName, String name) {
        this.deleteByNameAsync(resourceGroupName, namespaceName, eventHubName, name).block();
    }

    private EventHubConsumerGroupImpl wrapModel(ConsumerGroupInner innerModel) {
        return new EventHubConsumerGroupImpl(innerModel.name(), innerModel, this.manager);
    }
}

