/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.AuthorizationManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.KeyVaultManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.fluent.KeyVaultManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.fluent.VaultsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.fluent.models.DeletedVaultInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.fluent.models.VaultInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.implementation.CheckNameAvailabilityResultImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.implementation.DeletedVaultImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.implementation.VaultImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.CheckNameAvailabilityResult;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.CreateMode;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.DeletedVault;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.Sku;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.SkuFamily;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.SkuName;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.Vault;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.VaultCheckNameAvailabilityParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.VaultCreateOrUpdateParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.VaultProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.Vaults;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.UUID;

public class VaultsImpl
extends GroupableResourcesImpl<Vault, VaultImpl, VaultInner, VaultsClient, KeyVaultManager>
implements Vaults {
    private final AuthorizationManager authorizationManager;
    private final String tenantId;

    public VaultsImpl(KeyVaultManager keyVaultManager, AuthorizationManager authorizationManager, String tenantId) {
        super(((KeyVaultManagementClient)keyVaultManager.serviceClient()).getVaults(), keyVaultManager);
        this.authorizationManager = authorizationManager;
        this.tenantId = tenantId;
    }

    @Override
    public PagedIterable<Vault> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable<Vault>(this.listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    public PagedFlux<Vault> listByResourceGroupAsync(String resourceGroupName) {
        if (CoreUtils.isNullOrEmpty(resourceGroupName)) {
            return new PagedFlux<Vault>(() -> Mono.error(new IllegalArgumentException("Parameter 'resourceGroupName' is required and cannot be null.")));
        }
        return this.wrapPageAsync(((VaultsClient)this.inner()).listByResourceGroupAsync(resourceGroupName, null));
    }

    @Override
    protected Mono<VaultInner> getInnerAsync(String resourceGroupName, String name) {
        return ((VaultsClient)this.inner()).getByResourceGroupAsync(resourceGroupName, name);
    }

    @Override
    protected Mono<Void> deleteInnerAsync(String resourceGroupName, String name) {
        return ((VaultsClient)this.inner()).deleteAsync(resourceGroupName, name);
    }

    @Override
    public Mono<Void> deleteByResourceGroupAsync(String resourceGroupName, String name) {
        if (CoreUtils.isNullOrEmpty(resourceGroupName)) {
            return Mono.error(new IllegalArgumentException("Parameter 'resourceGroupName' is required and cannot be null."));
        }
        if (CoreUtils.isNullOrEmpty(name)) {
            return Mono.error(new IllegalArgumentException("Parameter 'name' is required and cannot be null."));
        }
        return ((VaultsClient)this.inner()).deleteAsync(resourceGroupName, name);
    }

    @Override
    public VaultImpl define(String name) {
        return this.wrapModel(name).withSku(SkuName.STANDARD).withEmptyAccessPolicy();
    }

    @Override
    protected VaultImpl wrapModel(String name) {
        VaultInner inner = new VaultInner().withProperties(new VaultProperties());
        inner.properties().withTenantId(UUID.fromString(this.tenantId));
        return new VaultImpl(name, inner, (KeyVaultManager)this.manager(), this.authorizationManager);
    }

    @Override
    protected VaultImpl wrapModel(VaultInner vaultInner) {
        if (vaultInner == null) {
            return null;
        }
        return new VaultImpl(vaultInner.name(), vaultInner, (KeyVaultManager)this.manager(), this.authorizationManager);
    }

    @Override
    public PagedIterable<DeletedVault> listDeleted() {
        return PagedConverter.mapPage(((VaultsClient)this.inner()).listDeleted(), DeletedVaultImpl::new);
    }

    @Override
    public DeletedVault getDeleted(String vaultName, String location) {
        DeletedVaultInner deletedVault = ((VaultsClient)this.inner()).getDeleted(vaultName, location);
        if (deletedVault == null) {
            return null;
        }
        return new DeletedVaultImpl(deletedVault);
    }

    @Override
    public void purgeDeleted(String vaultName, String location) {
        ((VaultsClient)this.inner()).purgeDeleted(vaultName, location);
    }

    @Override
    public Mono<DeletedVault> getDeletedAsync(String vaultName, String location) {
        return ((VaultsClient)this.inner()).getDeletedAsync(vaultName, location).map(DeletedVaultImpl::new);
    }

    @Override
    public Mono<Void> purgeDeletedAsync(String vaultName, String location) {
        return ((VaultsClient)this.inner()).purgeDeletedAsync(vaultName, location);
    }

    @Override
    public PagedFlux<DeletedVault> listDeletedAsync() {
        return PagedConverter.mapPage(((VaultsClient)this.inner()).listDeletedAsync(), DeletedVaultImpl::new);
    }

    @Override
    public CheckNameAvailabilityResult checkNameAvailability(String name) {
        return new CheckNameAvailabilityResultImpl(((VaultsClient)this.inner()).checkNameAvailability(new VaultCheckNameAvailabilityParameters().withName(name)));
    }

    @Override
    public Mono<CheckNameAvailabilityResult> checkNameAvailabilityAsync(String name) {
        return ((VaultsClient)this.inner()).checkNameAvailabilityAsync(new VaultCheckNameAvailabilityParameters().withName(name)).map(CheckNameAvailabilityResultImpl::new);
    }

    @Override
    public Vault recoverSoftDeletedVault(String resourceGroupName, String vaultName, String location) {
        return this.recoverSoftDeletedVaultAsync(resourceGroupName, vaultName, location).block();
    }

    @Override
    public Mono<Vault> recoverSoftDeletedVaultAsync(String resourceGroupName, String vaultName, String location) {
        KeyVaultManager manager = (KeyVaultManager)this.manager();
        return this.getDeletedAsync(vaultName, location).flatMap(deletedVault -> {
            VaultCreateOrUpdateParameters parameters = new VaultCreateOrUpdateParameters();
            parameters.withLocation(deletedVault.location());
            parameters.withTags(((DeletedVaultInner)deletedVault.innerModel()).properties().tags());
            parameters.withProperties(new VaultProperties().withCreateMode(CreateMode.RECOVER).withSku(new Sku().withName(SkuName.STANDARD).withFamily(SkuFamily.A)).withTenantId(UUID.fromString(this.tenantId)));
            return ((VaultsClient)this.inner()).createOrUpdateAsync(resourceGroupName, vaultName, parameters).map(inner -> new VaultImpl(inner.id(), (VaultInner)inner, manager, this.authorizationManager));
        });
    }
}

