/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.SystemData;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.fluent.models.MhsmPrivateLinkResourceProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.ManagedHsmResource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.ManagedHsmSku;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.ManagedServiceIdentity;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class MhsmPrivateLinkResource
extends ManagedHsmResource {
    private MhsmPrivateLinkResourceProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private MhsmPrivateLinkResourceProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public SystemData systemData() {
        return this.systemData;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public MhsmPrivateLinkResource withSku(ManagedHsmSku sku) {
        super.withSku(sku);
        return this;
    }

    @Override
    public MhsmPrivateLinkResource withIdentity(ManagedServiceIdentity identity) {
        super.withIdentity(identity);
        return this;
    }

    @Override
    public MhsmPrivateLinkResource withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public MhsmPrivateLinkResource withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    public String groupId() {
        return this.innerProperties() == null ? null : this.innerProperties().groupId();
    }

    public List<String> requiredMembers() {
        return this.innerProperties() == null ? null : this.innerProperties().requiredMembers();
    }

    public List<String> requiredZoneNames() {
        return this.innerProperties() == null ? null : this.innerProperties().requiredZoneNames();
    }

    public MhsmPrivateLinkResource withRequiredZoneNames(List<String> requiredZoneNames) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MhsmPrivateLinkResourceProperties();
        }
        this.innerProperties().withRequiredZoneNames(requiredZoneNames);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("sku", this.sku());
        jsonWriter.writeJsonField("identity", this.identity());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static MhsmPrivateLinkResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MhsmPrivateLinkResource deserializedMhsmPrivateLinkResource = new MhsmPrivateLinkResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMhsmPrivateLinkResource.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMhsmPrivateLinkResource.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMhsmPrivateLinkResource.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedMhsmPrivateLinkResource.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedMhsmPrivateLinkResource.withTags((Map)tags);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedMhsmPrivateLinkResource.withSku(ManagedHsmSku.fromJson(reader));
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedMhsmPrivateLinkResource.systemData = SystemData.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedMhsmPrivateLinkResource.withIdentity(ManagedServiceIdentity.fromJson(reader));
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedMhsmPrivateLinkResource.innerProperties = MhsmPrivateLinkResourceProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMhsmPrivateLinkResource;
        });
    }
}

