/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.AccessPolicyEntry;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.CreateMode;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.NetworkRuleSet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.Sku;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public final class VaultPatchProperties
implements JsonSerializable<VaultPatchProperties> {
    private UUID tenantId;
    private Sku sku;
    private List<AccessPolicyEntry> accessPolicies;
    private Boolean enabledForDeployment;
    private Boolean enabledForDiskEncryption;
    private Boolean enabledForTemplateDeployment;
    private Boolean enableSoftDelete;
    private Boolean enableRbacAuthorization;
    private Integer softDeleteRetentionInDays;
    private CreateMode createMode;
    private Boolean enablePurgeProtection;
    private NetworkRuleSet networkAcls;
    private String publicNetworkAccess;

    public UUID tenantId() {
        return this.tenantId;
    }

    public VaultPatchProperties withTenantId(UUID tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public Sku sku() {
        return this.sku;
    }

    public VaultPatchProperties withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public List<AccessPolicyEntry> accessPolicies() {
        return this.accessPolicies;
    }

    public VaultPatchProperties withAccessPolicies(List<AccessPolicyEntry> accessPolicies) {
        this.accessPolicies = accessPolicies;
        return this;
    }

    public Boolean enabledForDeployment() {
        return this.enabledForDeployment;
    }

    public VaultPatchProperties withEnabledForDeployment(Boolean enabledForDeployment) {
        this.enabledForDeployment = enabledForDeployment;
        return this;
    }

    public Boolean enabledForDiskEncryption() {
        return this.enabledForDiskEncryption;
    }

    public VaultPatchProperties withEnabledForDiskEncryption(Boolean enabledForDiskEncryption) {
        this.enabledForDiskEncryption = enabledForDiskEncryption;
        return this;
    }

    public Boolean enabledForTemplateDeployment() {
        return this.enabledForTemplateDeployment;
    }

    public VaultPatchProperties withEnabledForTemplateDeployment(Boolean enabledForTemplateDeployment) {
        this.enabledForTemplateDeployment = enabledForTemplateDeployment;
        return this;
    }

    public Boolean enableSoftDelete() {
        return this.enableSoftDelete;
    }

    public VaultPatchProperties withEnableSoftDelete(Boolean enableSoftDelete) {
        this.enableSoftDelete = enableSoftDelete;
        return this;
    }

    public Boolean enableRbacAuthorization() {
        return this.enableRbacAuthorization;
    }

    public VaultPatchProperties withEnableRbacAuthorization(Boolean enableRbacAuthorization) {
        this.enableRbacAuthorization = enableRbacAuthorization;
        return this;
    }

    public Integer softDeleteRetentionInDays() {
        return this.softDeleteRetentionInDays;
    }

    public VaultPatchProperties withSoftDeleteRetentionInDays(Integer softDeleteRetentionInDays) {
        this.softDeleteRetentionInDays = softDeleteRetentionInDays;
        return this;
    }

    public CreateMode createMode() {
        return this.createMode;
    }

    public VaultPatchProperties withCreateMode(CreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    public Boolean enablePurgeProtection() {
        return this.enablePurgeProtection;
    }

    public VaultPatchProperties withEnablePurgeProtection(Boolean enablePurgeProtection) {
        this.enablePurgeProtection = enablePurgeProtection;
        return this;
    }

    public NetworkRuleSet networkAcls() {
        return this.networkAcls;
    }

    public VaultPatchProperties withNetworkAcls(NetworkRuleSet networkAcls) {
        this.networkAcls = networkAcls;
        return this;
    }

    public String publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public VaultPatchProperties withPublicNetworkAccess(String publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.accessPolicies() != null) {
            this.accessPolicies().forEach(e -> e.validate());
        }
        if (this.networkAcls() != null) {
            this.networkAcls().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("tenantId", Objects.toString(this.tenantId, null));
        jsonWriter.writeJsonField("sku", this.sku);
        jsonWriter.writeArrayField("accessPolicies", this.accessPolicies, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeBooleanField("enabledForDeployment", this.enabledForDeployment);
        jsonWriter.writeBooleanField("enabledForDiskEncryption", this.enabledForDiskEncryption);
        jsonWriter.writeBooleanField("enabledForTemplateDeployment", this.enabledForTemplateDeployment);
        jsonWriter.writeBooleanField("enableSoftDelete", this.enableSoftDelete);
        jsonWriter.writeBooleanField("enableRbacAuthorization", this.enableRbacAuthorization);
        jsonWriter.writeNumberField("softDeleteRetentionInDays", this.softDeleteRetentionInDays);
        jsonWriter.writeStringField("createMode", this.createMode == null ? null : this.createMode.toString());
        jsonWriter.writeBooleanField("enablePurgeProtection", this.enablePurgeProtection);
        jsonWriter.writeJsonField("networkAcls", this.networkAcls);
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess);
        return jsonWriter.writeEndObject();
    }

    public static VaultPatchProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VaultPatchProperties deserializedVaultPatchProperties = new VaultPatchProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tenantId".equals(fieldName)) {
                    deserializedVaultPatchProperties.tenantId = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedVaultPatchProperties.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("accessPolicies".equals(fieldName)) {
                    List<AccessPolicyEntry> accessPolicies = reader.readArray(reader1 -> AccessPolicyEntry.fromJson(reader1));
                    deserializedVaultPatchProperties.accessPolicies = accessPolicies;
                    continue;
                }
                if ("enabledForDeployment".equals(fieldName)) {
                    deserializedVaultPatchProperties.enabledForDeployment = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enabledForDiskEncryption".equals(fieldName)) {
                    deserializedVaultPatchProperties.enabledForDiskEncryption = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enabledForTemplateDeployment".equals(fieldName)) {
                    deserializedVaultPatchProperties.enabledForTemplateDeployment = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableSoftDelete".equals(fieldName)) {
                    deserializedVaultPatchProperties.enableSoftDelete = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableRbacAuthorization".equals(fieldName)) {
                    deserializedVaultPatchProperties.enableRbacAuthorization = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("softDeleteRetentionInDays".equals(fieldName)) {
                    deserializedVaultPatchProperties.softDeleteRetentionInDays = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("createMode".equals(fieldName)) {
                    deserializedVaultPatchProperties.createMode = CreateMode.fromString(reader.getString());
                    continue;
                }
                if ("enablePurgeProtection".equals(fieldName)) {
                    deserializedVaultPatchProperties.enablePurgeProtection = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("networkAcls".equals(fieldName)) {
                    deserializedVaultPatchProperties.networkAcls = NetworkRuleSet.fromJson(reader);
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedVaultPatchProperties.publicNetworkAccess = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVaultPatchProperties;
        });
    }
}

