/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Resource;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.models.AlertRule;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.RuleAction;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.RuleCondition;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class AlertRuleResourceInner
extends Resource {
    private AlertRule innerProperties = new AlertRule();
    private String id;
    private String name;
    private String type;
    private static final ClientLogger LOGGER = new ClientLogger(AlertRuleResourceInner.class);

    private AlertRule innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public AlertRuleResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public AlertRuleResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String namePropertiesName() {
        return this.innerProperties() == null ? null : this.innerProperties().name();
    }

    public AlertRuleResourceInner withNamePropertiesName(String name) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AlertRule();
        }
        this.innerProperties().withName(name);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public AlertRuleResourceInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AlertRule();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public AlertRuleResourceInner withProvisioningState(String provisioningState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AlertRule();
        }
        this.innerProperties().withProvisioningState(provisioningState);
        return this;
    }

    public boolean isEnabled() {
        return this.innerProperties() == null ? false : this.innerProperties().isEnabled();
    }

    public AlertRuleResourceInner withIsEnabled(boolean isEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AlertRule();
        }
        this.innerProperties().withIsEnabled(isEnabled);
        return this;
    }

    public RuleCondition condition() {
        return this.innerProperties() == null ? null : this.innerProperties().condition();
    }

    public AlertRuleResourceInner withCondition(RuleCondition condition) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AlertRule();
        }
        this.innerProperties().withCondition(condition);
        return this;
    }

    public RuleAction action() {
        return this.innerProperties() == null ? null : this.innerProperties().action();
    }

    public AlertRuleResourceInner withAction(RuleAction action) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AlertRule();
        }
        this.innerProperties().withAction(action);
        return this;
    }

    public List<RuleAction> actions() {
        return this.innerProperties() == null ? null : this.innerProperties().actions();
    }

    public AlertRuleResourceInner withActions(List<RuleAction> actions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AlertRule();
        }
        this.innerProperties().withActions(actions);
        return this;
    }

    public OffsetDateTime lastUpdatedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastUpdatedTime();
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property innerProperties in model AlertRuleResourceInner"));
        }
        this.innerProperties().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static AlertRuleResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AlertRuleResourceInner deserializedAlertRuleResourceInner = new AlertRuleResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAlertRuleResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAlertRuleResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAlertRuleResourceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedAlertRuleResourceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAlertRuleResourceInner.withTags((Map)tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAlertRuleResourceInner.innerProperties = AlertRule.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAlertRuleResourceInner;
        });
    }
}

