/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.models.MetricBaselinesProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.TimeSeriesBaseline;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

public final class SingleMetricBaselineInner
implements JsonSerializable<SingleMetricBaselineInner> {
    private String id;
    private String type;
    private String name;
    private MetricBaselinesProperties innerProperties = new MetricBaselinesProperties();
    private static final ClientLogger LOGGER = new ClientLogger(SingleMetricBaselineInner.class);

    public String id() {
        return this.id;
    }

    public SingleMetricBaselineInner withId(String id) {
        this.id = id;
        return this;
    }

    public String type() {
        return this.type;
    }

    public SingleMetricBaselineInner withType(String type) {
        this.type = type;
        return this;
    }

    public String name() {
        return this.name;
    }

    public SingleMetricBaselineInner withName(String name) {
        this.name = name;
        return this;
    }

    private MetricBaselinesProperties innerProperties() {
        return this.innerProperties;
    }

    public String timespan() {
        return this.innerProperties() == null ? null : this.innerProperties().timespan();
    }

    public SingleMetricBaselineInner withTimespan(String timespan) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetricBaselinesProperties();
        }
        this.innerProperties().withTimespan(timespan);
        return this;
    }

    public Duration interval() {
        return this.innerProperties() == null ? null : this.innerProperties().interval();
    }

    public SingleMetricBaselineInner withInterval(Duration interval) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetricBaselinesProperties();
        }
        this.innerProperties().withInterval(interval);
        return this;
    }

    public String namespace() {
        return this.innerProperties() == null ? null : this.innerProperties().namespace();
    }

    public SingleMetricBaselineInner withNamespace(String namespace) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetricBaselinesProperties();
        }
        this.innerProperties().withNamespace(namespace);
        return this;
    }

    public List<TimeSeriesBaseline> baselines() {
        return this.innerProperties() == null ? null : this.innerProperties().baselines();
    }

    public SingleMetricBaselineInner withBaselines(List<TimeSeriesBaseline> baselines) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetricBaselinesProperties();
        }
        this.innerProperties().withBaselines(baselines);
        return this;
    }

    public void validate() {
        if (this.id() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property id in model SingleMetricBaselineInner"));
        }
        if (this.type() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property type in model SingleMetricBaselineInner"));
        }
        if (this.name() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property name in model SingleMetricBaselineInner"));
        }
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property innerProperties in model SingleMetricBaselineInner"));
        }
        this.innerProperties().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SingleMetricBaselineInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SingleMetricBaselineInner deserializedSingleMetricBaselineInner = new SingleMetricBaselineInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSingleMetricBaselineInner.id = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSingleMetricBaselineInner.type = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSingleMetricBaselineInner.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSingleMetricBaselineInner.innerProperties = MetricBaselinesProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSingleMetricBaselineInner;
        });
    }
}

