/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.DataContainer;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.DataStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.OnboardingStatus;
import java.io.IOException;
import java.util.List;

public final class VMInsightsOnboardingStatusProperties
implements JsonSerializable<VMInsightsOnboardingStatusProperties> {
    private String resourceId;
    private OnboardingStatus onboardingStatus;
    private DataStatus dataStatus;
    private List<DataContainer> data;
    private static final ClientLogger LOGGER = new ClientLogger(VMInsightsOnboardingStatusProperties.class);

    public String resourceId() {
        return this.resourceId;
    }

    public VMInsightsOnboardingStatusProperties withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public OnboardingStatus onboardingStatus() {
        return this.onboardingStatus;
    }

    public VMInsightsOnboardingStatusProperties withOnboardingStatus(OnboardingStatus onboardingStatus) {
        this.onboardingStatus = onboardingStatus;
        return this;
    }

    public DataStatus dataStatus() {
        return this.dataStatus;
    }

    public VMInsightsOnboardingStatusProperties withDataStatus(DataStatus dataStatus) {
        this.dataStatus = dataStatus;
        return this;
    }

    public List<DataContainer> data() {
        return this.data;
    }

    public VMInsightsOnboardingStatusProperties withData(List<DataContainer> data) {
        this.data = data;
        return this;
    }

    public void validate() {
        if (this.resourceId() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property resourceId in model VMInsightsOnboardingStatusProperties"));
        }
        if (this.onboardingStatus() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property onboardingStatus in model VMInsightsOnboardingStatusProperties"));
        }
        if (this.dataStatus() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property dataStatus in model VMInsightsOnboardingStatusProperties"));
        }
        if (this.data() != null) {
            this.data().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("onboardingStatus", this.onboardingStatus == null ? null : this.onboardingStatus.toString());
        jsonWriter.writeStringField("dataStatus", this.dataStatus == null ? null : this.dataStatus.toString());
        jsonWriter.writeArrayField("data", this.data, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static VMInsightsOnboardingStatusProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VMInsightsOnboardingStatusProperties deserializedVMInsightsOnboardingStatusProperties = new VMInsightsOnboardingStatusProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceId".equals(fieldName)) {
                    deserializedVMInsightsOnboardingStatusProperties.resourceId = reader.getString();
                    continue;
                }
                if ("onboardingStatus".equals(fieldName)) {
                    deserializedVMInsightsOnboardingStatusProperties.onboardingStatus = OnboardingStatus.fromString(reader.getString());
                    continue;
                }
                if ("dataStatus".equals(fieldName)) {
                    deserializedVMInsightsOnboardingStatusProperties.dataStatus = DataStatus.fromString(reader.getString());
                    continue;
                }
                if ("data".equals(fieldName)) {
                    List<DataContainer> data = reader.readArray(reader1 -> DataContainer.fromJson(reader1));
                    deserializedVMInsightsOnboardingStatusProperties.data = data;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVMInsightsOnboardingStatusProperties;
        });
    }
}

