/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.BodyParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Delete;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Patch;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Put;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.LogProfilesClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.models.LogProfileResourceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.implementation.MonitorClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.LogProfileCollection;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.LogProfileResourcePatch;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class LogProfilesClientImpl
implements LogProfilesClient {
    private final LogProfilesService service;
    private final MonitorClientImpl client;

    LogProfilesClientImpl(MonitorClientImpl client) {
        this.service = RestProxy.create(LogProfilesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String logProfileName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (logProfileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter logProfileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2016-03-01";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), logProfileName, "2016-03-01", this.client.getSubscriptionId(), (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String logProfileName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (logProfileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter logProfileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2016-03-01";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), logProfileName, "2016-03-01", this.client.getSubscriptionId(), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String logProfileName) {
        return this.deleteWithResponseAsync(logProfileName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String logProfileName, Context context) {
        return this.deleteWithResponseAsync(logProfileName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String logProfileName) {
        this.deleteWithResponse(logProfileName, Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LogProfileResourceInner>> getWithResponseAsync(String logProfileName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (logProfileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter logProfileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2016-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), logProfileName, "2016-03-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<LogProfileResourceInner>> getWithResponseAsync(String logProfileName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (logProfileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter logProfileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2016-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), logProfileName, "2016-03-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LogProfileResourceInner> getAsync(String logProfileName) {
        return this.getWithResponseAsync(logProfileName).flatMap(res -> Mono.justOrEmpty((LogProfileResourceInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LogProfileResourceInner> getWithResponse(String logProfileName, Context context) {
        return this.getWithResponseAsync(logProfileName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public LogProfileResourceInner get(String logProfileName) {
        return this.getWithResponse(logProfileName, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LogProfileResourceInner>> createOrUpdateWithResponseAsync(String logProfileName, LogProfileResourceInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (logProfileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter logProfileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2016-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), logProfileName, "2016-03-01", this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<LogProfileResourceInner>> createOrUpdateWithResponseAsync(String logProfileName, LogProfileResourceInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (logProfileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter logProfileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2016-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), logProfileName, "2016-03-01", this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LogProfileResourceInner> createOrUpdateAsync(String logProfileName, LogProfileResourceInner parameters) {
        return this.createOrUpdateWithResponseAsync(logProfileName, parameters).flatMap(res -> Mono.justOrEmpty((LogProfileResourceInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LogProfileResourceInner> createOrUpdateWithResponse(String logProfileName, LogProfileResourceInner parameters, Context context) {
        return this.createOrUpdateWithResponseAsync(logProfileName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public LogProfileResourceInner createOrUpdate(String logProfileName, LogProfileResourceInner parameters) {
        return this.createOrUpdateWithResponse(logProfileName, parameters, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LogProfileResourceInner>> updateWithResponseAsync(String logProfileName, LogProfileResourcePatch logProfilesResource) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (logProfileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter logProfileName is required and cannot be null."));
        }
        if (logProfilesResource == null) {
            return Mono.error(new IllegalArgumentException("Parameter logProfilesResource is required and cannot be null."));
        }
        logProfilesResource.validate();
        String apiVersion = "2016-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), logProfileName, "2016-03-01", logProfilesResource, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<LogProfileResourceInner>> updateWithResponseAsync(String logProfileName, LogProfileResourcePatch logProfilesResource, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (logProfileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter logProfileName is required and cannot be null."));
        }
        if (logProfilesResource == null) {
            return Mono.error(new IllegalArgumentException("Parameter logProfilesResource is required and cannot be null."));
        }
        logProfilesResource.validate();
        String apiVersion = "2016-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), logProfileName, "2016-03-01", logProfilesResource, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LogProfileResourceInner> updateAsync(String logProfileName, LogProfileResourcePatch logProfilesResource) {
        return this.updateWithResponseAsync(logProfileName, logProfilesResource).flatMap(res -> Mono.justOrEmpty((LogProfileResourceInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LogProfileResourceInner> updateWithResponse(String logProfileName, LogProfileResourcePatch logProfilesResource, Context context) {
        return this.updateWithResponseAsync(logProfileName, logProfilesResource, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public LogProfileResourceInner update(String logProfileName, LogProfileResourcePatch logProfilesResource) {
        return this.updateWithResponse(logProfileName, logProfilesResource, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LogProfileResourceInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2016-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2016-03-01", this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, LogProfileResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LogProfileCollection)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LogProfileResourceInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2016-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2016-03-01", this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase<Object, LogProfileResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LogProfileCollection)res.getValue()).value(), null, null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<LogProfileResourceInner> listAsync() {
        return new PagedFlux<LogProfileResourceInner>(() -> this.listSinglePageAsync());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<LogProfileResourceInner> listAsync(Context context) {
        return new PagedFlux<LogProfileResourceInner>(() -> this.listSinglePageAsync(context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LogProfileResourceInner> list() {
        return new PagedIterable<LogProfileResourceInner>(this.listAsync());
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LogProfileResourceInner> list(Context context) {
        return new PagedIterable<LogProfileResourceInner>(this.listAsync(context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MonitorClientLogProf")
    public static interface LogProfilesService {
        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/providers/Microsoft.Insights/logprofiles/{logProfileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="logProfileName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Insights/logprofiles/{logProfileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LogProfileResourceInner>> get(@HostParam(value="$host") String var1, @PathParam(value="logProfileName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/providers/Microsoft.Insights/logprofiles/{logProfileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LogProfileResourceInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="logProfileName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @BodyParam(value="application/json") LogProfileResourceInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/providers/Microsoft.Insights/logprofiles/{logProfileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LogProfileResourceInner>> update(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="logProfileName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") LogProfileResourcePatch var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Insights/logprofiles")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LogProfileCollection>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

