/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.MetricDefinitionsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.models.MetricDefinitionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.implementation.MonitorClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.MetricDefinitionCollection;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class MetricDefinitionsClientImpl
implements MetricDefinitionsClient {
    private final MetricDefinitionsService service;
    private final MonitorClientImpl client;

    MetricDefinitionsClientImpl(MonitorClientImpl client) {
        this.service = RestProxy.create(MetricDefinitionsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MetricDefinitionInner>> listSinglePageAsync(String resourceUri, String metricnamespace) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String apiVersion = "2018-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceUri, "2018-01-01", metricnamespace, "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, MetricDefinitionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricDefinitionCollection)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MetricDefinitionInner>> listSinglePageAsync(String resourceUri, String metricnamespace, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String apiVersion = "2018-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceUri, "2018-01-01", metricnamespace, "application/json", context).map(res -> new PagedResponseBase<Object, MetricDefinitionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricDefinitionCollection)res.getValue()).value(), null, null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MetricDefinitionInner> listAsync(String resourceUri, String metricnamespace) {
        return new PagedFlux<MetricDefinitionInner>(() -> this.listSinglePageAsync(resourceUri, metricnamespace));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MetricDefinitionInner> listAsync(String resourceUri) {
        String metricnamespace = null;
        return new PagedFlux<MetricDefinitionInner>(() -> this.listSinglePageAsync(resourceUri, metricnamespace));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MetricDefinitionInner> listAsync(String resourceUri, String metricnamespace, Context context) {
        return new PagedFlux<MetricDefinitionInner>(() -> this.listSinglePageAsync(resourceUri, metricnamespace, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MetricDefinitionInner> list(String resourceUri) {
        String metricnamespace = null;
        return new PagedIterable<MetricDefinitionInner>(this.listAsync(resourceUri, metricnamespace));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MetricDefinitionInner> list(String resourceUri, String metricnamespace, Context context) {
        return new PagedIterable<MetricDefinitionInner>(this.listAsync(resourceUri, metricnamespace, context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MonitorClientMetricD")
    public static interface MetricDefinitionsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceUri}/providers/Microsoft.Insights/metricDefinitions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<MetricDefinitionCollection>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceUri", encoded=true) String var2, @QueryParam(value="api-version") String var3, @QueryParam(value="metricnamespace") String var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

