/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineBuilder;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.RetryPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.UserAgentPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.AzureEnvironment;
import com.dataiku.dss.shadelibazure.com.azure.core.management.serializer.SerializerFactory;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.SerializerAdapter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.implementation.MonitorClientImpl;
import java.time.Duration;

@ServiceClientBuilder(serviceClients={MonitorClientImpl.class})
public final class MonitorClientBuilder {
    private String subscriptionId;
    private String endpoint;
    private AzureEnvironment environment;
    private HttpPipeline pipeline;
    private Duration defaultPollInterval;
    private SerializerAdapter serializerAdapter;

    public MonitorClientBuilder subscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public MonitorClientBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public MonitorClientBuilder environment(AzureEnvironment environment) {
        this.environment = environment;
        return this;
    }

    public MonitorClientBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public MonitorClientBuilder defaultPollInterval(Duration defaultPollInterval) {
        this.defaultPollInterval = defaultPollInterval;
        return this;
    }

    public MonitorClientBuilder serializerAdapter(SerializerAdapter serializerAdapter) {
        this.serializerAdapter = serializerAdapter;
        return this;
    }

    public MonitorClientImpl buildClient() {
        String localEndpoint = this.endpoint != null ? this.endpoint : "https://management.azure.com";
        AzureEnvironment localEnvironment = this.environment != null ? this.environment : AzureEnvironment.AZURE;
        HttpPipeline localPipeline = this.pipeline != null ? this.pipeline : new HttpPipelineBuilder().policies(new UserAgentPolicy(), new RetryPolicy()).build();
        Duration localDefaultPollInterval = this.defaultPollInterval != null ? this.defaultPollInterval : Duration.ofSeconds(30L);
        SerializerAdapter localSerializerAdapter = this.serializerAdapter != null ? this.serializerAdapter : SerializerFactory.createDefaultManagementSerializerAdapter();
        MonitorClientImpl client = new MonitorClientImpl(localPipeline, localSerializerAdapter, localDefaultPollInterval, localEnvironment, this.subscriptionId, localEndpoint);
        return client;
    }
}

