/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.ConditionFailingPeriods;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.ConditionOperator;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.Dimension;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.TimeAggregation;
import java.io.IOException;
import java.util.List;

public final class Condition
implements JsonSerializable<Condition> {
    private String query;
    private TimeAggregation timeAggregation;
    private String metricMeasureColumn;
    private String resourceIdColumn;
    private List<Dimension> dimensions;
    private ConditionOperator operator;
    private Double threshold;
    private ConditionFailingPeriods failingPeriods;
    private String metricName;

    public String query() {
        return this.query;
    }

    public Condition withQuery(String query) {
        this.query = query;
        return this;
    }

    public TimeAggregation timeAggregation() {
        return this.timeAggregation;
    }

    public Condition withTimeAggregation(TimeAggregation timeAggregation) {
        this.timeAggregation = timeAggregation;
        return this;
    }

    public String metricMeasureColumn() {
        return this.metricMeasureColumn;
    }

    public Condition withMetricMeasureColumn(String metricMeasureColumn) {
        this.metricMeasureColumn = metricMeasureColumn;
        return this;
    }

    public String resourceIdColumn() {
        return this.resourceIdColumn;
    }

    public Condition withResourceIdColumn(String resourceIdColumn) {
        this.resourceIdColumn = resourceIdColumn;
        return this;
    }

    public List<Dimension> dimensions() {
        return this.dimensions;
    }

    public Condition withDimensions(List<Dimension> dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public ConditionOperator operator() {
        return this.operator;
    }

    public Condition withOperator(ConditionOperator operator) {
        this.operator = operator;
        return this;
    }

    public Double threshold() {
        return this.threshold;
    }

    public Condition withThreshold(Double threshold) {
        this.threshold = threshold;
        return this;
    }

    public ConditionFailingPeriods failingPeriods() {
        return this.failingPeriods;
    }

    public Condition withFailingPeriods(ConditionFailingPeriods failingPeriods) {
        this.failingPeriods = failingPeriods;
        return this;
    }

    public String metricName() {
        return this.metricName;
    }

    public Condition withMetricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    public void validate() {
        if (this.dimensions() != null) {
            this.dimensions().forEach(e -> e.validate());
        }
        if (this.failingPeriods() != null) {
            this.failingPeriods().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("query", this.query);
        jsonWriter.writeStringField("timeAggregation", this.timeAggregation == null ? null : this.timeAggregation.toString());
        jsonWriter.writeStringField("metricMeasureColumn", this.metricMeasureColumn);
        jsonWriter.writeStringField("resourceIdColumn", this.resourceIdColumn);
        jsonWriter.writeArrayField("dimensions", this.dimensions, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeStringField("operator", this.operator == null ? null : this.operator.toString());
        jsonWriter.writeNumberField("threshold", this.threshold);
        jsonWriter.writeJsonField("failingPeriods", this.failingPeriods);
        jsonWriter.writeStringField("metricName", this.metricName);
        return jsonWriter.writeEndObject();
    }

    public static Condition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Condition deserializedCondition = new Condition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("query".equals(fieldName)) {
                    deserializedCondition.query = reader.getString();
                    continue;
                }
                if ("timeAggregation".equals(fieldName)) {
                    deserializedCondition.timeAggregation = TimeAggregation.fromString(reader.getString());
                    continue;
                }
                if ("metricMeasureColumn".equals(fieldName)) {
                    deserializedCondition.metricMeasureColumn = reader.getString();
                    continue;
                }
                if ("resourceIdColumn".equals(fieldName)) {
                    deserializedCondition.resourceIdColumn = reader.getString();
                    continue;
                }
                if ("dimensions".equals(fieldName)) {
                    List<Dimension> dimensions = reader.readArray(reader1 -> Dimension.fromJson(reader1));
                    deserializedCondition.dimensions = dimensions;
                    continue;
                }
                if ("operator".equals(fieldName)) {
                    deserializedCondition.operator = ConditionOperator.fromString(reader.getString());
                    continue;
                }
                if ("threshold".equals(fieldName)) {
                    deserializedCondition.threshold = reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("failingPeriods".equals(fieldName)) {
                    deserializedCondition.failingPeriods = ConditionFailingPeriods.fromJson(reader);
                    continue;
                }
                if ("metricName".equals(fieldName)) {
                    deserializedCondition.metricName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCondition;
        });
    }
}

