/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class IisLogsDataSource
implements JsonSerializable<IisLogsDataSource> {
    private List<String> streams;
    private List<String> logDirectories;
    private String name;
    private static final ClientLogger LOGGER = new ClientLogger(IisLogsDataSource.class);

    public List<String> streams() {
        return this.streams;
    }

    public IisLogsDataSource withStreams(List<String> streams) {
        this.streams = streams;
        return this;
    }

    public List<String> logDirectories() {
        return this.logDirectories;
    }

    public IisLogsDataSource withLogDirectories(List<String> logDirectories) {
        this.logDirectories = logDirectories;
        return this;
    }

    public String name() {
        return this.name;
    }

    public IisLogsDataSource withName(String name) {
        this.name = name;
        return this;
    }

    public void validate() {
        if (this.streams() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property streams in model IisLogsDataSource"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("streams", this.streams, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("logDirectories", this.logDirectories, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static IisLogsDataSource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IisLogsDataSource deserializedIisLogsDataSource = new IisLogsDataSource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("streams".equals(fieldName)) {
                    List<String> streams = reader.readArray(reader1 -> reader1.getString());
                    deserializedIisLogsDataSource.streams = streams;
                    continue;
                }
                if ("logDirectories".equals(fieldName)) {
                    List<String> logDirectories = reader.readArray(reader1 -> reader1.getString());
                    deserializedIisLogsDataSource.logDirectories = logDirectories;
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedIisLogsDataSource.name = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIisLogsDataSource;
        });
    }
}

