/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.MetricAlertCriteria;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.Odatatype;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class WebtestLocationAvailabilityCriteria
extends MetricAlertCriteria {
    private Odatatype odataType = Odatatype.MICROSOFT_AZURE_MONITOR_WEBTEST_LOCATION_AVAILABILITY_CRITERIA;
    private String webTestId;
    private String componentId;
    private float failedLocationCount;
    private static final ClientLogger LOGGER = new ClientLogger(WebtestLocationAvailabilityCriteria.class);

    @Override
    public Odatatype odataType() {
        return this.odataType;
    }

    public String webTestId() {
        return this.webTestId;
    }

    public WebtestLocationAvailabilityCriteria withWebTestId(String webTestId) {
        this.webTestId = webTestId;
        return this;
    }

    public String componentId() {
        return this.componentId;
    }

    public WebtestLocationAvailabilityCriteria withComponentId(String componentId) {
        this.componentId = componentId;
        return this;
    }

    public float failedLocationCount() {
        return this.failedLocationCount;
    }

    public WebtestLocationAvailabilityCriteria withFailedLocationCount(float failedLocationCount) {
        this.failedLocationCount = failedLocationCount;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.webTestId() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property webTestId in model WebtestLocationAvailabilityCriteria"));
        }
        if (this.componentId() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property componentId in model WebtestLocationAvailabilityCriteria"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("webTestId", this.webTestId);
        jsonWriter.writeStringField("componentId", this.componentId);
        jsonWriter.writeFloatField("failedLocationCount", this.failedLocationCount);
        jsonWriter.writeStringField("odata.type", this.odataType == null ? null : this.odataType.toString());
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static WebtestLocationAvailabilityCriteria fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WebtestLocationAvailabilityCriteria deserializedWebtestLocationAvailabilityCriteria = new WebtestLocationAvailabilityCriteria();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("webTestId".equals(fieldName)) {
                    deserializedWebtestLocationAvailabilityCriteria.webTestId = reader.getString();
                    continue;
                }
                if ("componentId".equals(fieldName)) {
                    deserializedWebtestLocationAvailabilityCriteria.componentId = reader.getString();
                    continue;
                }
                if ("failedLocationCount".equals(fieldName)) {
                    deserializedWebtestLocationAvailabilityCriteria.failedLocationCount = reader.getFloat();
                    continue;
                }
                if ("odata.type".equals(fieldName)) {
                    deserializedWebtestLocationAvailabilityCriteria.odataType = Odatatype.fromString(reader.getString());
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedWebtestLocationAvailabilityCriteria.withAdditionalProperties(additionalProperties);
            return deserializedWebtestLocationAvailabilityCriteria;
        });
    }
}

