/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Resource;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.ExpressRouteServiceProviderPropertiesFormat;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ExpressRouteServiceProviderBandwidthsOffered;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ExpressRouteServiceProviderInner
extends Resource {
    private ExpressRouteServiceProviderPropertiesFormat innerProperties;
    private String id;
    private String type;
    private String name;

    private ExpressRouteServiceProviderPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    public ExpressRouteServiceProviderInner withId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ExpressRouteServiceProviderInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public ExpressRouteServiceProviderInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public List<String> peeringLocations() {
        return this.innerProperties() == null ? null : this.innerProperties().peeringLocations();
    }

    public ExpressRouteServiceProviderInner withPeeringLocations(List<String> peeringLocations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteServiceProviderPropertiesFormat();
        }
        this.innerProperties().withPeeringLocations(peeringLocations);
        return this;
    }

    public List<ExpressRouteServiceProviderBandwidthsOffered> bandwidthsOffered() {
        return this.innerProperties() == null ? null : this.innerProperties().bandwidthsOffered();
    }

    public ExpressRouteServiceProviderInner withBandwidthsOffered(List<ExpressRouteServiceProviderBandwidthsOffered> bandwidthsOffered) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteServiceProviderPropertiesFormat();
        }
        this.innerProperties().withBandwidthsOffered(bandwidthsOffered);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static ExpressRouteServiceProviderInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRouteServiceProviderInner deserializedExpressRouteServiceProviderInner = new ExpressRouteServiceProviderInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedExpressRouteServiceProviderInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedExpressRouteServiceProviderInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedExpressRouteServiceProviderInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedExpressRouteServiceProviderInner.withTags((Map)tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedExpressRouteServiceProviderInner.innerProperties = ExpressRouteServiceProviderPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedExpressRouteServiceProviderInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExpressRouteServiceProviderInner;
        });
    }
}

