/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.RoutingConfiguration;
import java.io.IOException;

public final class HubVirtualNetworkConnectionProperties
implements JsonSerializable<HubVirtualNetworkConnectionProperties> {
    private SubResource remoteVirtualNetwork;
    private Boolean allowHubToRemoteVnetTransit;
    private Boolean allowRemoteVnetToUseHubVnetGateways;
    private Boolean enableInternetSecurity;
    private RoutingConfiguration routingConfiguration;
    private ProvisioningState provisioningState;

    public SubResource remoteVirtualNetwork() {
        return this.remoteVirtualNetwork;
    }

    public HubVirtualNetworkConnectionProperties withRemoteVirtualNetwork(SubResource remoteVirtualNetwork) {
        this.remoteVirtualNetwork = remoteVirtualNetwork;
        return this;
    }

    public Boolean allowHubToRemoteVnetTransit() {
        return this.allowHubToRemoteVnetTransit;
    }

    public HubVirtualNetworkConnectionProperties withAllowHubToRemoteVnetTransit(Boolean allowHubToRemoteVnetTransit) {
        this.allowHubToRemoteVnetTransit = allowHubToRemoteVnetTransit;
        return this;
    }

    public Boolean allowRemoteVnetToUseHubVnetGateways() {
        return this.allowRemoteVnetToUseHubVnetGateways;
    }

    public HubVirtualNetworkConnectionProperties withAllowRemoteVnetToUseHubVnetGateways(Boolean allowRemoteVnetToUseHubVnetGateways) {
        this.allowRemoteVnetToUseHubVnetGateways = allowRemoteVnetToUseHubVnetGateways;
        return this;
    }

    public Boolean enableInternetSecurity() {
        return this.enableInternetSecurity;
    }

    public HubVirtualNetworkConnectionProperties withEnableInternetSecurity(Boolean enableInternetSecurity) {
        this.enableInternetSecurity = enableInternetSecurity;
        return this;
    }

    public RoutingConfiguration routingConfiguration() {
        return this.routingConfiguration;
    }

    public HubVirtualNetworkConnectionProperties withRoutingConfiguration(RoutingConfiguration routingConfiguration) {
        this.routingConfiguration = routingConfiguration;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.routingConfiguration() != null) {
            this.routingConfiguration().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("remoteVirtualNetwork", this.remoteVirtualNetwork);
        jsonWriter.writeBooleanField("allowHubToRemoteVnetTransit", this.allowHubToRemoteVnetTransit);
        jsonWriter.writeBooleanField("allowRemoteVnetToUseHubVnetGateways", this.allowRemoteVnetToUseHubVnetGateways);
        jsonWriter.writeBooleanField("enableInternetSecurity", this.enableInternetSecurity);
        jsonWriter.writeJsonField("routingConfiguration", this.routingConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static HubVirtualNetworkConnectionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HubVirtualNetworkConnectionProperties deserializedHubVirtualNetworkConnectionProperties = new HubVirtualNetworkConnectionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("remoteVirtualNetwork".equals(fieldName)) {
                    deserializedHubVirtualNetworkConnectionProperties.remoteVirtualNetwork = SubResource.fromJson(reader);
                    continue;
                }
                if ("allowHubToRemoteVnetTransit".equals(fieldName)) {
                    deserializedHubVirtualNetworkConnectionProperties.allowHubToRemoteVnetTransit = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("allowRemoteVnetToUseHubVnetGateways".equals(fieldName)) {
                    deserializedHubVirtualNetworkConnectionProperties.allowRemoteVnetToUseHubVnetGateways = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableInternetSecurity".equals(fieldName)) {
                    deserializedHubVirtualNetworkConnectionProperties.enableInternetSecurity = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("routingConfiguration".equals(fieldName)) {
                    deserializedHubVirtualNetworkConnectionProperties.routingConfiguration = RoutingConfiguration.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedHubVirtualNetworkConnectionProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHubVirtualNetworkConnectionProperties;
        });
    }
}

