/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PacketCaptureFilter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PacketCaptureMachineScope;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PacketCaptureSettings;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PacketCaptureStorageLocation;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PacketCaptureTargetType;
import java.io.IOException;
import java.util.List;

public class PacketCaptureParameters
implements JsonSerializable<PacketCaptureParameters> {
    private String target;
    private PacketCaptureMachineScope scope;
    private PacketCaptureTargetType targetType;
    private Long bytesToCapturePerPacket;
    private Long totalBytesPerSession;
    private Integer timeLimitInSeconds;
    private PacketCaptureStorageLocation storageLocation;
    private List<PacketCaptureFilter> filters;
    private Boolean continuousCapture;
    private PacketCaptureSettings captureSettings;
    private static final ClientLogger LOGGER = new ClientLogger(PacketCaptureParameters.class);

    public String target() {
        return this.target;
    }

    public PacketCaptureParameters withTarget(String target) {
        this.target = target;
        return this;
    }

    public PacketCaptureMachineScope scope() {
        return this.scope;
    }

    public PacketCaptureParameters withScope(PacketCaptureMachineScope scope) {
        this.scope = scope;
        return this;
    }

    public PacketCaptureTargetType targetType() {
        return this.targetType;
    }

    public PacketCaptureParameters withTargetType(PacketCaptureTargetType targetType) {
        this.targetType = targetType;
        return this;
    }

    public Long bytesToCapturePerPacket() {
        return this.bytesToCapturePerPacket;
    }

    public PacketCaptureParameters withBytesToCapturePerPacket(Long bytesToCapturePerPacket) {
        this.bytesToCapturePerPacket = bytesToCapturePerPacket;
        return this;
    }

    public Long totalBytesPerSession() {
        return this.totalBytesPerSession;
    }

    public PacketCaptureParameters withTotalBytesPerSession(Long totalBytesPerSession) {
        this.totalBytesPerSession = totalBytesPerSession;
        return this;
    }

    public Integer timeLimitInSeconds() {
        return this.timeLimitInSeconds;
    }

    public PacketCaptureParameters withTimeLimitInSeconds(Integer timeLimitInSeconds) {
        this.timeLimitInSeconds = timeLimitInSeconds;
        return this;
    }

    public PacketCaptureStorageLocation storageLocation() {
        return this.storageLocation;
    }

    public PacketCaptureParameters withStorageLocation(PacketCaptureStorageLocation storageLocation) {
        this.storageLocation = storageLocation;
        return this;
    }

    public List<PacketCaptureFilter> filters() {
        return this.filters;
    }

    public PacketCaptureParameters withFilters(List<PacketCaptureFilter> filters) {
        this.filters = filters;
        return this;
    }

    public Boolean continuousCapture() {
        return this.continuousCapture;
    }

    public PacketCaptureParameters withContinuousCapture(Boolean continuousCapture) {
        this.continuousCapture = continuousCapture;
        return this;
    }

    public PacketCaptureSettings captureSettings() {
        return this.captureSettings;
    }

    public PacketCaptureParameters withCaptureSettings(PacketCaptureSettings captureSettings) {
        this.captureSettings = captureSettings;
        return this;
    }

    public void validate() {
        if (this.target() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property target in model PacketCaptureParameters"));
        }
        if (this.scope() != null) {
            this.scope().validate();
        }
        if (this.storageLocation() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property storageLocation in model PacketCaptureParameters"));
        }
        this.storageLocation().validate();
        if (this.filters() != null) {
            this.filters().forEach(e -> e.validate());
        }
        if (this.captureSettings() != null) {
            this.captureSettings().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("target", this.target);
        jsonWriter.writeJsonField("storageLocation", this.storageLocation);
        jsonWriter.writeJsonField("scope", this.scope);
        jsonWriter.writeStringField("targetType", this.targetType == null ? null : this.targetType.toString());
        jsonWriter.writeNumberField("bytesToCapturePerPacket", this.bytesToCapturePerPacket);
        jsonWriter.writeNumberField("totalBytesPerSession", this.totalBytesPerSession);
        jsonWriter.writeNumberField("timeLimitInSeconds", this.timeLimitInSeconds);
        jsonWriter.writeArrayField("filters", this.filters, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeBooleanField("continuousCapture", this.continuousCapture);
        jsonWriter.writeJsonField("captureSettings", this.captureSettings);
        return jsonWriter.writeEndObject();
    }

    public static PacketCaptureParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PacketCaptureParameters deserializedPacketCaptureParameters = new PacketCaptureParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("target".equals(fieldName)) {
                    deserializedPacketCaptureParameters.target = reader.getString();
                    continue;
                }
                if ("storageLocation".equals(fieldName)) {
                    deserializedPacketCaptureParameters.storageLocation = PacketCaptureStorageLocation.fromJson(reader);
                    continue;
                }
                if ("scope".equals(fieldName)) {
                    deserializedPacketCaptureParameters.scope = PacketCaptureMachineScope.fromJson(reader);
                    continue;
                }
                if ("targetType".equals(fieldName)) {
                    deserializedPacketCaptureParameters.targetType = PacketCaptureTargetType.fromString(reader.getString());
                    continue;
                }
                if ("bytesToCapturePerPacket".equals(fieldName)) {
                    deserializedPacketCaptureParameters.bytesToCapturePerPacket = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("totalBytesPerSession".equals(fieldName)) {
                    deserializedPacketCaptureParameters.totalBytesPerSession = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("timeLimitInSeconds".equals(fieldName)) {
                    deserializedPacketCaptureParameters.timeLimitInSeconds = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("filters".equals(fieldName)) {
                    List<PacketCaptureFilter> filters = reader.readArray(reader1 -> PacketCaptureFilter.fromJson(reader1));
                    deserializedPacketCaptureParameters.filters = filters;
                    continue;
                }
                if ("continuousCapture".equals(fieldName)) {
                    deserializedPacketCaptureParameters.continuousCapture = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("captureSettings".equals(fieldName)) {
                    deserializedPacketCaptureParameters.captureSettings = PacketCaptureSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPacketCaptureParameters;
        });
    }
}

