/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.PacketCaptureParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PacketCaptureFilter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PacketCaptureMachineScope;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PacketCaptureSettings;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PacketCaptureStorageLocation;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PacketCaptureTargetType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class PacketCaptureResultProperties
extends PacketCaptureParameters {
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(PacketCaptureResultProperties.class);

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    @Override
    public PacketCaptureResultProperties withTarget(String target) {
        super.withTarget(target);
        return this;
    }

    @Override
    public PacketCaptureResultProperties withScope(PacketCaptureMachineScope scope) {
        super.withScope(scope);
        return this;
    }

    @Override
    public PacketCaptureResultProperties withTargetType(PacketCaptureTargetType targetType) {
        super.withTargetType(targetType);
        return this;
    }

    @Override
    public PacketCaptureResultProperties withBytesToCapturePerPacket(Long bytesToCapturePerPacket) {
        super.withBytesToCapturePerPacket(bytesToCapturePerPacket);
        return this;
    }

    @Override
    public PacketCaptureResultProperties withTotalBytesPerSession(Long totalBytesPerSession) {
        super.withTotalBytesPerSession(totalBytesPerSession);
        return this;
    }

    @Override
    public PacketCaptureResultProperties withTimeLimitInSeconds(Integer timeLimitInSeconds) {
        super.withTimeLimitInSeconds(timeLimitInSeconds);
        return this;
    }

    @Override
    public PacketCaptureResultProperties withStorageLocation(PacketCaptureStorageLocation storageLocation) {
        super.withStorageLocation(storageLocation);
        return this;
    }

    @Override
    public PacketCaptureResultProperties withFilters(List<PacketCaptureFilter> filters) {
        super.withFilters(filters);
        return this;
    }

    @Override
    public PacketCaptureResultProperties withContinuousCapture(Boolean continuousCapture) {
        super.withContinuousCapture(continuousCapture);
        return this;
    }

    @Override
    public PacketCaptureResultProperties withCaptureSettings(PacketCaptureSettings captureSettings) {
        super.withCaptureSettings(captureSettings);
        return this;
    }

    @Override
    public void validate() {
        if (this.target() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property target in model PacketCaptureResultProperties"));
        }
        if (this.scope() != null) {
            this.scope().validate();
        }
        if (this.storageLocation() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property storageLocation in model PacketCaptureResultProperties"));
        }
        this.storageLocation().validate();
        if (this.filters() != null) {
            this.filters().forEach(e -> e.validate());
        }
        if (this.captureSettings() != null) {
            this.captureSettings().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("target", this.target());
        jsonWriter.writeJsonField("storageLocation", this.storageLocation());
        jsonWriter.writeJsonField("scope", this.scope());
        jsonWriter.writeStringField("targetType", this.targetType() == null ? null : this.targetType().toString());
        jsonWriter.writeNumberField("bytesToCapturePerPacket", this.bytesToCapturePerPacket());
        jsonWriter.writeNumberField("totalBytesPerSession", this.totalBytesPerSession());
        jsonWriter.writeNumberField("timeLimitInSeconds", this.timeLimitInSeconds());
        jsonWriter.writeArrayField("filters", this.filters(), (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeBooleanField("continuousCapture", this.continuousCapture());
        jsonWriter.writeJsonField("captureSettings", this.captureSettings());
        return jsonWriter.writeEndObject();
    }

    public static PacketCaptureResultProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PacketCaptureResultProperties deserializedPacketCaptureResultProperties = new PacketCaptureResultProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("target".equals(fieldName)) {
                    deserializedPacketCaptureResultProperties.withTarget(reader.getString());
                    continue;
                }
                if ("storageLocation".equals(fieldName)) {
                    deserializedPacketCaptureResultProperties.withStorageLocation(PacketCaptureStorageLocation.fromJson(reader));
                    continue;
                }
                if ("scope".equals(fieldName)) {
                    deserializedPacketCaptureResultProperties.withScope(PacketCaptureMachineScope.fromJson(reader));
                    continue;
                }
                if ("targetType".equals(fieldName)) {
                    deserializedPacketCaptureResultProperties.withTargetType(PacketCaptureTargetType.fromString(reader.getString()));
                    continue;
                }
                if ("bytesToCapturePerPacket".equals(fieldName)) {
                    deserializedPacketCaptureResultProperties.withBytesToCapturePerPacket(reader.getNullable(JsonReader::getLong));
                    continue;
                }
                if ("totalBytesPerSession".equals(fieldName)) {
                    deserializedPacketCaptureResultProperties.withTotalBytesPerSession(reader.getNullable(JsonReader::getLong));
                    continue;
                }
                if ("timeLimitInSeconds".equals(fieldName)) {
                    deserializedPacketCaptureResultProperties.withTimeLimitInSeconds(reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("filters".equals(fieldName)) {
                    List<PacketCaptureFilter> filters = reader.readArray(reader1 -> PacketCaptureFilter.fromJson(reader1));
                    deserializedPacketCaptureResultProperties.withFilters((List)filters);
                    continue;
                }
                if ("continuousCapture".equals(fieldName)) {
                    deserializedPacketCaptureResultProperties.withContinuousCapture(reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("captureSettings".equals(fieldName)) {
                    deserializedPacketCaptureResultProperties.withCaptureSettings(PacketCaptureSettings.fromJson(reader));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedPacketCaptureResultProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPacketCaptureResultProperties;
        });
    }
}

