/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class PoolAssociationInner
implements JsonSerializable<PoolAssociationInner> {
    private String resourceId;
    private String poolId;
    private String description;
    private List<String> addressPrefixes;
    private List<String> reservedPrefixes;
    private String totalNumberOfIpAddresses;
    private String numberOfReservedIpAddresses;
    private OffsetDateTime createdAt;
    private OffsetDateTime reservationExpiresAt;
    private static final ClientLogger LOGGER = new ClientLogger(PoolAssociationInner.class);

    public String resourceId() {
        return this.resourceId;
    }

    public PoolAssociationInner withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public String poolId() {
        return this.poolId;
    }

    public PoolAssociationInner withPoolId(String poolId) {
        this.poolId = poolId;
        return this;
    }

    public String description() {
        return this.description;
    }

    public PoolAssociationInner withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<String> addressPrefixes() {
        return this.addressPrefixes;
    }

    public List<String> reservedPrefixes() {
        return this.reservedPrefixes;
    }

    public String totalNumberOfIpAddresses() {
        return this.totalNumberOfIpAddresses;
    }

    public String numberOfReservedIpAddresses() {
        return this.numberOfReservedIpAddresses;
    }

    public OffsetDateTime createdAt() {
        return this.createdAt;
    }

    public OffsetDateTime reservationExpiresAt() {
        return this.reservationExpiresAt;
    }

    public void validate() {
        if (this.resourceId() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property resourceId in model PoolAssociationInner"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("poolId", this.poolId);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static PoolAssociationInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PoolAssociationInner deserializedPoolAssociationInner = new PoolAssociationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceId".equals(fieldName)) {
                    deserializedPoolAssociationInner.resourceId = reader.getString();
                    continue;
                }
                if ("poolId".equals(fieldName)) {
                    deserializedPoolAssociationInner.poolId = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedPoolAssociationInner.description = reader.getString();
                    continue;
                }
                if ("addressPrefixes".equals(fieldName)) {
                    List<String> addressPrefixes = reader.readArray(reader1 -> reader1.getString());
                    deserializedPoolAssociationInner.addressPrefixes = addressPrefixes;
                    continue;
                }
                if ("reservedPrefixes".equals(fieldName)) {
                    List<String> reservedPrefixes = reader.readArray(reader1 -> reader1.getString());
                    deserializedPoolAssociationInner.reservedPrefixes = reservedPrefixes;
                    continue;
                }
                if ("totalNumberOfIPAddresses".equals(fieldName)) {
                    deserializedPoolAssociationInner.totalNumberOfIpAddresses = reader.getString();
                    continue;
                }
                if ("numberOfReservedIPAddresses".equals(fieldName)) {
                    deserializedPoolAssociationInner.numberOfReservedIpAddresses = reader.getString();
                    continue;
                }
                if ("createdAt".equals(fieldName)) {
                    deserializedPoolAssociationInner.createdAt = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("reservationExpiresAt".equals(fieldName)) {
                    deserializedPoolAssociationInner.reservationExpiresAt = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPoolAssociationInner;
        });
    }
}

