/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.RouteMapRule;
import java.io.IOException;
import java.util.List;

public final class RouteMapProperties
implements JsonSerializable<RouteMapProperties> {
    private List<String> associatedInboundConnections;
    private List<String> associatedOutboundConnections;
    private List<RouteMapRule> rules;
    private ProvisioningState provisioningState;

    public List<String> associatedInboundConnections() {
        return this.associatedInboundConnections;
    }

    public RouteMapProperties withAssociatedInboundConnections(List<String> associatedInboundConnections) {
        this.associatedInboundConnections = associatedInboundConnections;
        return this;
    }

    public List<String> associatedOutboundConnections() {
        return this.associatedOutboundConnections;
    }

    public RouteMapProperties withAssociatedOutboundConnections(List<String> associatedOutboundConnections) {
        this.associatedOutboundConnections = associatedOutboundConnections;
        return this;
    }

    public List<RouteMapRule> rules() {
        return this.rules;
    }

    public RouteMapProperties withRules(List<RouteMapRule> rules) {
        this.rules = rules;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.rules() != null) {
            this.rules().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("associatedInboundConnections", this.associatedInboundConnections, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("associatedOutboundConnections", this.associatedOutboundConnections, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static RouteMapProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RouteMapProperties deserializedRouteMapProperties = new RouteMapProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("associatedInboundConnections".equals(fieldName)) {
                    List<String> associatedInboundConnections = reader.readArray(reader1 -> reader1.getString());
                    deserializedRouteMapProperties.associatedInboundConnections = associatedInboundConnections;
                    continue;
                }
                if ("associatedOutboundConnections".equals(fieldName)) {
                    List<String> associatedOutboundConnections = reader.readArray(reader1 -> reader1.getString());
                    deserializedRouteMapProperties.associatedOutboundConnections = associatedOutboundConnections;
                    continue;
                }
                if ("rules".equals(fieldName)) {
                    List<RouteMapRule> rules = reader.readArray(reader1 -> RouteMapRule.fromJson(reader1));
                    deserializedRouteMapProperties.rules = rules;
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedRouteMapProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRouteMapProperties;
        });
    }
}

