/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.VirtualNetworkGatewayPolicyGroupMember;
import java.io.IOException;
import java.util.List;

public final class VirtualNetworkGatewayPolicyGroupProperties
implements JsonSerializable<VirtualNetworkGatewayPolicyGroupProperties> {
    private boolean isDefault;
    private int priority;
    private List<VirtualNetworkGatewayPolicyGroupMember> policyMembers;
    private List<SubResource> vngClientConnectionConfigurations;
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(VirtualNetworkGatewayPolicyGroupProperties.class);

    public boolean isDefault() {
        return this.isDefault;
    }

    public VirtualNetworkGatewayPolicyGroupProperties withIsDefault(boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    public int priority() {
        return this.priority;
    }

    public VirtualNetworkGatewayPolicyGroupProperties withPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public List<VirtualNetworkGatewayPolicyGroupMember> policyMembers() {
        return this.policyMembers;
    }

    public VirtualNetworkGatewayPolicyGroupProperties withPolicyMembers(List<VirtualNetworkGatewayPolicyGroupMember> policyMembers) {
        this.policyMembers = policyMembers;
        return this;
    }

    public List<SubResource> vngClientConnectionConfigurations() {
        return this.vngClientConnectionConfigurations;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.policyMembers() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property policyMembers in model VirtualNetworkGatewayPolicyGroupProperties"));
        }
        this.policyMembers().forEach(e -> e.validate());
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isDefault", this.isDefault);
        jsonWriter.writeIntField("priority", this.priority);
        jsonWriter.writeArrayField("policyMembers", this.policyMembers, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static VirtualNetworkGatewayPolicyGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualNetworkGatewayPolicyGroupProperties deserializedVirtualNetworkGatewayPolicyGroupProperties = new VirtualNetworkGatewayPolicyGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("isDefault".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayPolicyGroupProperties.isDefault = reader.getBoolean();
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayPolicyGroupProperties.priority = reader.getInt();
                    continue;
                }
                if ("policyMembers".equals(fieldName)) {
                    List<VirtualNetworkGatewayPolicyGroupMember> policyMembers = reader.readArray(reader1 -> VirtualNetworkGatewayPolicyGroupMember.fromJson(reader1));
                    deserializedVirtualNetworkGatewayPolicyGroupProperties.policyMembers = policyMembers;
                    continue;
                }
                if ("vngClientConnectionConfigurations".equals(fieldName)) {
                    List<SubResource> vngClientConnectionConfigurations = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedVirtualNetworkGatewayPolicyGroupProperties.vngClientConnectionConfigurations = vngClientConnectionConfigurations;
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayPolicyGroupProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualNetworkGatewayPolicyGroupProperties;
        });
    }
}

