/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.NetworkManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.ExpressRouteCrossConnectionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.ExpressRouteCrossConnectionPeeringInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.ExpressRouteCrossConnectionPeeringImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.ExpressRouteCrossConnectionPeeringsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.GroupableParentResourceWithTagsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ExpressRouteCircuitReference;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ExpressRouteCrossConnection;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ExpressRouteCrossConnectionPeering;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ExpressRouteCrossConnectionPeerings;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ServiceProviderProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.TagsObject;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ExpressRouteCrossConnectionImpl
extends GroupableParentResourceWithTagsImpl<ExpressRouteCrossConnection, ExpressRouteCrossConnectionInner, ExpressRouteCrossConnectionImpl, NetworkManager>
implements ExpressRouteCrossConnection,
ExpressRouteCrossConnection.Update {
    private ExpressRouteCrossConnectionPeeringsImpl peerings;
    private Map<String, ExpressRouteCrossConnectionPeering> crossConnectionPeerings;

    ExpressRouteCrossConnectionImpl(String name, ExpressRouteCrossConnectionInner innerObject, NetworkManager manager) {
        super(name, innerObject, manager);
        this.initializeChildrenFromInner();
    }

    @Override
    protected Mono<ExpressRouteCrossConnectionInner> createInner() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getExpressRouteCrossConnections().createOrUpdateAsync(this.resourceGroupName(), this.name(), (ExpressRouteCrossConnectionInner)this.innerModel());
    }

    @Override
    protected void initializeChildrenFromInner() {
        this.crossConnectionPeerings = new HashMap<String, ExpressRouteCrossConnectionPeering>();
        if (((ExpressRouteCrossConnectionInner)this.innerModel()).peerings() != null) {
            for (ExpressRouteCrossConnectionPeeringInner peering : ((ExpressRouteCrossConnectionInner)this.innerModel()).peerings()) {
                this.crossConnectionPeerings.put(peering.name(), new ExpressRouteCrossConnectionPeeringImpl(this, peering, peering.peeringType()));
            }
        }
    }

    @Override
    protected Mono<ExpressRouteCrossConnectionInner> getInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getExpressRouteCrossConnections().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public Mono<ExpressRouteCrossConnection> refreshAsync() {
        return super.refreshAsync().map(expressRouteCrossConnection -> {
            ExpressRouteCrossConnectionImpl impl = (ExpressRouteCrossConnectionImpl)expressRouteCrossConnection;
            impl.initializeChildrenFromInner();
            return impl;
        });
    }

    @Override
    protected Mono<ExpressRouteCrossConnectionInner> applyTagsToInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getExpressRouteCrossConnections().updateTagsAsync(this.resourceGroupName(), this.name(), new TagsObject().withTags(((ExpressRouteCrossConnectionInner)this.innerModel()).tags()));
    }

    @Override
    public ExpressRouteCrossConnectionPeerings peerings() {
        if (this.peerings == null) {
            this.peerings = new ExpressRouteCrossConnectionPeeringsImpl(this);
        }
        return this.peerings;
    }

    @Override
    public String primaryAzurePort() {
        return ((ExpressRouteCrossConnectionInner)this.innerModel()).primaryAzurePort();
    }

    @Override
    public String secondaryAzurePort() {
        return ((ExpressRouteCrossConnectionInner)this.innerModel()).secondaryAzurePort();
    }

    @Override
    public Integer stag() {
        return ((ExpressRouteCrossConnectionInner)this.innerModel()).stag();
    }

    @Override
    public String peeringLocation() {
        return ((ExpressRouteCrossConnectionInner)this.innerModel()).peeringLocation();
    }

    @Override
    public int bandwidthInMbps() {
        return ResourceManagerUtils.toPrimitiveInt(((ExpressRouteCrossConnectionInner)this.innerModel()).bandwidthInMbps());
    }

    @Override
    public ExpressRouteCircuitReference expressRouteCircuit() {
        return ((ExpressRouteCrossConnectionInner)this.innerModel()).expressRouteCircuit();
    }

    @Override
    public ServiceProviderProvisioningState serviceProviderProvisioningState() {
        return ((ExpressRouteCrossConnectionInner)this.innerModel()).serviceProviderProvisioningState();
    }

    @Override
    public String serviceProviderNotes() {
        return ((ExpressRouteCrossConnectionInner)this.innerModel()).serviceProviderNotes();
    }

    @Override
    public String provisioningState() {
        return ((ExpressRouteCrossConnectionInner)this.innerModel()).provisioningState().toString();
    }

    @Override
    public Map<String, ExpressRouteCrossConnectionPeering> peeringsMap() {
        return Collections.unmodifiableMap(this.crossConnectionPeerings);
    }

    @Override
    public ExpressRouteCrossConnection.Update withServiceProviderProvisioningState(ServiceProviderProvisioningState state) {
        ((ExpressRouteCrossConnectionInner)this.innerModel()).withServiceProviderProvisioningState(state);
        return this;
    }

    @Override
    public ExpressRouteCrossConnection.Update withServiceProviderNotes(String notes) {
        ((ExpressRouteCrossConnectionInner)this.innerModel()).withServiceProviderNotes(notes);
        return this;
    }
}

