/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.NetworkManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.FlowLogInformationInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.NetworkWatcherImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.FlowLogSettings;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.FlowLogStatusParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.RetentionPolicyParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.implementation.RefreshableWrapperImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

class FlowLogSettingsImpl
extends RefreshableWrapperImpl<FlowLogInformationInner, FlowLogSettings>
implements FlowLogSettings,
FlowLogSettings.Update {
    private final NetworkWatcherImpl parent;
    private final String nsgId;

    FlowLogSettingsImpl(NetworkWatcherImpl parent, FlowLogInformationInner inner, String nsgId) {
        super(inner);
        this.parent = parent;
        this.nsgId = nsgId;
    }

    @Override
    public FlowLogSettings apply() {
        return this.applyAsync().block();
    }

    @Override
    public Mono<FlowLogSettings> applyAsync() {
        return this.applyAsync(Context.NONE);
    }

    @Override
    public FlowLogSettings apply(Context context) {
        return this.applyAsync(context).block();
    }

    @Override
    public Mono<FlowLogSettings> applyAsync(Context context) {
        return ((NetworkManagementClient)((NetworkManager)this.parent().manager()).serviceClient()).getNetworkWatchers().setFlowLogConfigurationAsync(this.parent().resourceGroupName(), this.parent().name(), (FlowLogInformationInner)this.innerModel()).contextWrite(c -> c.putAll(FluxUtil.toReactorContext(context).readOnly())).map(flowLogInformationInner -> new FlowLogSettingsImpl(this.parent, (FlowLogInformationInner)flowLogInformationInner, this.nsgId));
    }

    @Override
    public FlowLogSettings.Update withLogging() {
        ((FlowLogInformationInner)this.innerModel()).withEnabled(true);
        return this;
    }

    @Override
    public FlowLogSettings.Update withoutLogging() {
        ((FlowLogInformationInner)this.innerModel()).withEnabled(false);
        return this;
    }

    @Override
    public FlowLogSettings.Update withStorageAccount(String storageId) {
        ((FlowLogInformationInner)this.innerModel()).withStorageId(storageId);
        return this;
    }

    @Override
    public FlowLogSettings.Update withRetentionPolicyEnabled() {
        this.ensureRetentionPolicy();
        ((FlowLogInformationInner)this.innerModel()).retentionPolicy().withEnabled(true);
        return this;
    }

    @Override
    public FlowLogSettings.Update withRetentionPolicyDisabled() {
        this.ensureRetentionPolicy();
        ((FlowLogInformationInner)this.innerModel()).retentionPolicy().withEnabled(false);
        return this;
    }

    @Override
    public FlowLogSettings.Update withRetentionPolicyDays(int days) {
        this.ensureRetentionPolicy();
        ((FlowLogInformationInner)this.innerModel()).retentionPolicy().withDays(days);
        return this;
    }

    private void ensureRetentionPolicy() {
        if (((FlowLogInformationInner)this.innerModel()).retentionPolicy() == null) {
            ((FlowLogInformationInner)this.innerModel()).withRetentionPolicy(new RetentionPolicyParameters());
        }
    }

    @Override
    public FlowLogSettings.Update update() {
        if (((FlowLogInformationInner)this.innerModel()).flowAnalyticsConfiguration() != null && ((FlowLogInformationInner)this.innerModel()).flowAnalyticsConfiguration().networkWatcherFlowAnalyticsConfiguration() == null) {
            ((FlowLogInformationInner)this.innerModel()).withFlowAnalyticsConfiguration(null);
        }
        return this;
    }

    @Override
    protected Mono<FlowLogInformationInner> getInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.parent().manager()).serviceClient()).getNetworkWatchers().getFlowLogStatusAsync(this.parent().resourceGroupName(), this.parent().name(), new FlowLogStatusParameters().withTargetResourceId(((FlowLogInformationInner)this.innerModel()).targetResourceId()));
    }

    @Override
    public NetworkWatcherImpl parent() {
        return this.parent;
    }

    @Override
    public String key() {
        return null;
    }

    @Override
    public String targetResourceId() {
        return ((FlowLogInformationInner)this.innerModel()).targetResourceId();
    }

    @Override
    public String storageId() {
        return ((FlowLogInformationInner)this.innerModel()).storageId();
    }

    @Override
    public boolean enabled() {
        return ResourceManagerUtils.toPrimitiveBoolean(((FlowLogInformationInner)this.innerModel()).enabled());
    }

    @Override
    public boolean isRetentionEnabled() {
        this.ensureRetentionPolicy();
        return ResourceManagerUtils.toPrimitiveBoolean(((FlowLogInformationInner)this.innerModel()).retentionPolicy().enabled());
    }

    @Override
    public int retentionDays() {
        this.ensureRetentionPolicy();
        return ResourceManagerUtils.toPrimitiveInt(((FlowLogInformationInner)this.innerModel()).retentionPolicy().days());
    }

    @Override
    public String networkSecurityGroupId() {
        return this.nsgId;
    }
}

