/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.NetworkManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.NetworkSecurityGroupsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.NetworkSecurityGroupInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.NetworkSecurityGroupImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkInterface;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkSecurityGroup;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkSecurityGroups;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public class NetworkSecurityGroupsImpl
extends TopLevelModifiableResourcesImpl<NetworkSecurityGroup, NetworkSecurityGroupImpl, NetworkSecurityGroupInner, NetworkSecurityGroupsClient, NetworkManager>
implements NetworkSecurityGroups {
    public NetworkSecurityGroupsImpl(NetworkManager networkManager) {
        super(((NetworkManagementClient)networkManager.serviceClient()).getNetworkSecurityGroups(), networkManager);
    }

    @Override
    public Mono<Void> deleteByResourceGroupAsync(String resourceGroupName, String name) {
        if (CoreUtils.isNullOrEmpty(resourceGroupName)) {
            return Mono.error(new IllegalArgumentException("Parameter 'resourceGroupName' is required and cannot be null."));
        }
        if (CoreUtils.isNullOrEmpty(name)) {
            return Mono.error(new IllegalArgumentException("Parameter 'name' is required and cannot be null."));
        }
        return this.getByResourceGroupAsync(resourceGroupName, name).flatMapMany(nsg -> Flux.fromIterable(nsg.networkInterfaceIds()).flatMap(nicRef -> ((NetworkManager)this.manager()).networkInterfaces().getByIdAsync((String)nicRef)).flatMap(nic -> {
            if (nic == null) {
                return Mono.empty();
            }
            if (!nsg.id().equalsIgnoreCase(nic.networkSecurityGroupId())) {
                return Mono.empty();
            }
            return ((NetworkInterface.Update)nic.update()).withoutNetworkSecurityGroup().applyAsync();
        })).then(this.deleteInnerAsync(resourceGroupName, name)).subscribeOn(ResourceManagerUtils.InternalRuntimeContext.getReactorScheduler());
    }

    @Override
    public NetworkSecurityGroupImpl define(String name) {
        return this.wrapModel(name);
    }

    @Override
    protected NetworkSecurityGroupImpl wrapModel(String name) {
        NetworkSecurityGroupInner inner = new NetworkSecurityGroupInner();
        return new NetworkSecurityGroupImpl(name, inner, (NetworkManager)this.manager());
    }

    @Override
    protected NetworkSecurityGroupImpl wrapModel(NetworkSecurityGroupInner inner) {
        if (inner == null) {
            return null;
        }
        return new NetworkSecurityGroupImpl(inner.name(), inner, (NetworkManager)this.manager());
    }
}

