/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.NetworkManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.PrivateEndpointInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.PrivateDnsZoneGroupsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.CustomDnsConfigPropertiesFormat;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PrivateDnsZoneGroups;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PrivateEndpoint;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PrivateLinkServiceConnection;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PrivateLinkServiceConnectionState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PrivateLinkSubResourceName;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.Subnet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

class PrivateEndpointImpl
extends GroupableResourceImpl<PrivateEndpoint, PrivateEndpointInner, PrivateEndpointImpl, NetworkManager>
implements PrivateEndpoint,
PrivateEndpoint.Definition,
PrivateEndpoint.Update {
    private final ClientLogger logger = new ClientLogger(PrivateEndpointImpl.class);
    private PrivateDnsZoneGroups privateDnsZoneGroups;

    protected PrivateEndpointImpl(String name, PrivateEndpointInner innerObject, NetworkManager manager) {
        super(name, innerObject, manager);
    }

    @Override
    public PrivateDnsZoneGroups privateDnsZoneGroups() {
        if (this.privateDnsZoneGroups == null) {
            this.privateDnsZoneGroups = new PrivateDnsZoneGroupsImpl(this);
        }
        return this.privateDnsZoneGroups;
    }

    @Override
    public SubResource subnet() {
        return new SubResource().withId(((PrivateEndpointInner)this.innerModel()).subnet().id());
    }

    @Override
    public List<SubResource> networkInterfaces() {
        if (((PrivateEndpointInner)this.innerModel()).networkInterfaces() == null) {
            return Collections.emptyList();
        }
        return ((PrivateEndpointInner)this.innerModel()).networkInterfaces().stream().map(ni -> new SubResource().withId(ni.id())).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    @Override
    public ProvisioningState provisioningState() {
        return ((PrivateEndpointInner)this.innerModel()).provisioningState();
    }

    @Override
    public Map<String, PrivateEndpoint.PrivateLinkServiceConnection> privateLinkServiceConnections() {
        HashMap connections = new HashMap();
        if (((PrivateEndpointInner)this.innerModel()).privateLinkServiceConnections() != null) {
            connections.putAll(((PrivateEndpointInner)this.innerModel()).privateLinkServiceConnections().stream().map(connection -> new PrivateEndpointConnectionImpl((PrivateLinkServiceConnection)connection, this, false)).collect(Collectors.toMap(PrivateEndpointConnectionImpl::name, Function.identity())));
        }
        if (((PrivateEndpointInner)this.innerModel()).manualPrivateLinkServiceConnections() != null) {
            connections.putAll(((PrivateEndpointInner)this.innerModel()).manualPrivateLinkServiceConnections().stream().map(connection -> new PrivateEndpointConnectionImpl((PrivateLinkServiceConnection)connection, this, true)).collect(Collectors.toMap(PrivateEndpointConnectionImpl::name, Function.identity())));
        }
        return Collections.unmodifiableMap(connections);
    }

    @Override
    public List<CustomDnsConfigPropertiesFormat> customDnsConfigurations() {
        if (((PrivateEndpointInner)this.innerModel()).networkInterfaces() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(((PrivateEndpointInner)this.innerModel()).customDnsConfigs());
    }

    @Override
    public PrivateEndpointImpl withSubnet(Subnet subnet) {
        ((PrivateEndpointInner)this.innerModel()).withSubnet((SubnetInner)Objects.requireNonNull(subnet).innerModel());
        return this;
    }

    @Override
    public PrivateEndpointImpl withSubnetId(String subnetId) {
        ((PrivateEndpointInner)this.innerModel()).withSubnet(new SubnetInner().withId(Objects.requireNonNull(subnetId)));
        return this;
    }

    @Override
    public PrivateEndpointImpl withoutPrivateLinkServiceConnection(String name) {
        if (((PrivateEndpointInner)this.innerModel()).privateLinkServiceConnections() != null) {
            ((PrivateEndpointInner)this.innerModel()).privateLinkServiceConnections().removeIf(connection -> connection.name().equals(name));
        }
        if (((PrivateEndpointInner)this.innerModel()).manualPrivateLinkServiceConnections() != null) {
            ((PrivateEndpointInner)this.innerModel()).manualPrivateLinkServiceConnections().removeIf(connection -> connection.name().equals(name));
        }
        return this;
    }

    public PrivateEndpointConnectionImpl definePrivateLinkServiceConnection(String name) {
        return new PrivateEndpointConnectionImpl(Objects.requireNonNull(name), this);
    }

    @Override
    public PrivateEndpoint.PrivateLinkServiceConnection.Update updatePrivateLinkServiceConnection(String name) {
        Optional<PrivateLinkServiceConnection> connection;
        if (((PrivateEndpointInner)this.innerModel()).privateLinkServiceConnections() != null && (connection = ((PrivateEndpointInner)this.innerModel()).privateLinkServiceConnections().stream().filter(c -> c.name().equals(name)).findAny()).isPresent()) {
            return new PrivateEndpointConnectionImpl(connection.get(), this, false);
        }
        if (((PrivateEndpointInner)this.innerModel()).manualPrivateLinkServiceConnections() != null && (connection = ((PrivateEndpointInner)this.innerModel()).manualPrivateLinkServiceConnections().stream().filter(c -> c.name().equals(name)).findAny()).isPresent()) {
            return new PrivateEndpointConnectionImpl(connection.get(), this, true);
        }
        throw this.logger.logExceptionAsError(new IllegalArgumentException(String.format("Private link service connection not found for name '%s'", name)));
    }

    PrivateEndpointImpl withPrivateEndpointConnection(PrivateEndpointConnectionImpl connection) {
        if (connection.isManualApproval()) {
            if (((PrivateEndpointInner)this.innerModel()).manualPrivateLinkServiceConnections() == null) {
                ((PrivateEndpointInner)this.innerModel()).withManualPrivateLinkServiceConnections(new ArrayList<PrivateLinkServiceConnection>());
            }
            ((PrivateEndpointInner)this.innerModel()).manualPrivateLinkServiceConnections().add((PrivateLinkServiceConnection)connection.innerModel());
        } else {
            if (((PrivateEndpointInner)this.innerModel()).privateLinkServiceConnections() == null) {
                ((PrivateEndpointInner)this.innerModel()).withPrivateLinkServiceConnections(new ArrayList<PrivateLinkServiceConnection>());
            }
            ((PrivateEndpointInner)this.innerModel()).privateLinkServiceConnections().add((PrivateLinkServiceConnection)connection.innerModel());
        }
        return this;
    }

    @Override
    public Mono<PrivateEndpoint> createResourceAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getPrivateEndpoints().createOrUpdateAsync(this.resourceGroupName(), this.name(), (PrivateEndpointInner)this.innerModel()).map(this.innerToFluentMap(this));
    }

    @Override
    protected Mono<PrivateEndpointInner> getInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getPrivateEndpoints().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    static class PrivateEndpointConnectionImpl
    extends ChildResourceImpl<PrivateLinkServiceConnection, PrivateEndpointImpl, PrivateEndpoint>
    implements PrivateEndpoint.PrivateLinkServiceConnection,
    PrivateEndpoint.PrivateLinkServiceConnection.Definition<PrivateEndpointImpl>,
    PrivateEndpoint.PrivateLinkServiceConnection.Update {
        private boolean manualApproval = false;

        PrivateEndpointConnectionImpl(String name, PrivateEndpointImpl parent) {
            super(new PrivateLinkServiceConnection().withName(name), parent);
        }

        PrivateEndpointConnectionImpl(PrivateLinkServiceConnection innerModel, PrivateEndpointImpl parent, boolean manualApproval) {
            super(innerModel, parent);
            this.manualApproval = manualApproval;
        }

        @Override
        public String name() {
            return ((PrivateLinkServiceConnection)this.innerModel()).name();
        }

        @Override
        public PrivateLinkServiceConnectionState state() {
            return ((PrivateLinkServiceConnection)this.innerModel()).privateLinkServiceConnectionState();
        }

        @Override
        public String privateLinkResourceId() {
            return ((PrivateLinkServiceConnection)this.innerModel()).privateLinkServiceId();
        }

        @Override
        public List<PrivateLinkSubResourceName> subResourceNames() {
            if (((PrivateLinkServiceConnection)this.innerModel()).groupIds() == null) {
                return Collections.emptyList();
            }
            return ((PrivateLinkServiceConnection)this.innerModel()).groupIds().stream().map(PrivateLinkSubResourceName::fromString).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        }

        @Override
        public String requestMessage() {
            return ((PrivateLinkServiceConnection)this.innerModel()).requestMessage();
        }

        @Override
        public ProvisioningState provisioningState() {
            return ((PrivateLinkServiceConnection)this.innerModel()).provisioningState();
        }

        @Override
        public boolean isManualApproval() {
            return this.manualApproval;
        }

        @Override
        public PrivateEndpointImpl attach() {
            return ((PrivateEndpointImpl)this.parent()).withPrivateEndpointConnection(this);
        }

        public PrivateEndpointConnectionImpl withResource(Resource privateLinkServiceResource) {
            ((PrivateLinkServiceConnection)this.innerModel()).withPrivateLinkServiceId(Objects.requireNonNull(privateLinkServiceResource).id());
            return this;
        }

        public PrivateEndpointConnectionImpl withResourceId(String privateLinkServiceResourceId) {
            ((PrivateLinkServiceConnection)this.innerModel()).withPrivateLinkServiceId(Objects.requireNonNull(privateLinkServiceResourceId));
            return this;
        }

        public PrivateEndpointConnectionImpl withSubResource(PrivateLinkSubResourceName subResourceName) {
            ((PrivateLinkServiceConnection)this.innerModel()).withGroupIds(Collections.singletonList(Objects.requireNonNull(subResourceName).toString()));
            return this;
        }

        public PrivateEndpointConnectionImpl withoutSubResource() {
            ((PrivateLinkServiceConnection)this.innerModel()).withGroupIds(null);
            return this;
        }

        public PrivateEndpointConnectionImpl withManualApproval(String requestMessage) {
            this.manualApproval = true;
            ((PrivateLinkServiceConnection)this.innerModel()).withRequestMessage(requestMessage);
            return this;
        }

        @Override
        public PrivateEndpointConnectionImpl withRequestMessage(String requestMessage) {
            ((PrivateLinkServiceConnection)this.innerModel()).withRequestMessage(requestMessage);
            return this;
        }
    }
}

