/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.DefaultAdminPropertiesFormat;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ActiveBaseSecurityAdminRule;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.AddressPrefixItem;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ConfigurationGroup;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.EffectiveAdminRuleKind;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkManagerSecurityGroupItem;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.SecurityConfigurationRuleAccess;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.SecurityConfigurationRuleDirection;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.SecurityConfigurationRuleProtocol;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class ActiveDefaultSecurityAdminRule
extends ActiveBaseSecurityAdminRule {
    private EffectiveAdminRuleKind kind = EffectiveAdminRuleKind.DEFAULT;
    private DefaultAdminPropertiesFormat innerProperties;

    @Override
    public EffectiveAdminRuleKind kind() {
        return this.kind;
    }

    private DefaultAdminPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    @Override
    public ActiveDefaultSecurityAdminRule withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public ActiveDefaultSecurityAdminRule withCommitTime(OffsetDateTime commitTime) {
        super.withCommitTime(commitTime);
        return this;
    }

    @Override
    public ActiveDefaultSecurityAdminRule withRegion(String region) {
        super.withRegion(region);
        return this;
    }

    @Override
    public ActiveDefaultSecurityAdminRule withConfigurationDescription(String configurationDescription) {
        super.withConfigurationDescription(configurationDescription);
        return this;
    }

    @Override
    public ActiveDefaultSecurityAdminRule withRuleCollectionDescription(String ruleCollectionDescription) {
        super.withRuleCollectionDescription(ruleCollectionDescription);
        return this;
    }

    @Override
    public ActiveDefaultSecurityAdminRule withRuleCollectionAppliesToGroups(List<NetworkManagerSecurityGroupItem> ruleCollectionAppliesToGroups) {
        super.withRuleCollectionAppliesToGroups(ruleCollectionAppliesToGroups);
        return this;
    }

    @Override
    public ActiveDefaultSecurityAdminRule withRuleGroups(List<ConfigurationGroup> ruleGroups) {
        super.withRuleGroups(ruleGroups);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public String flag() {
        return this.innerProperties() == null ? null : this.innerProperties().flag();
    }

    public ActiveDefaultSecurityAdminRule withFlag(String flag) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DefaultAdminPropertiesFormat();
        }
        this.innerProperties().withFlag(flag);
        return this;
    }

    public SecurityConfigurationRuleProtocol protocol() {
        return this.innerProperties() == null ? null : this.innerProperties().protocol();
    }

    public List<AddressPrefixItem> sources() {
        return this.innerProperties() == null ? null : this.innerProperties().sources();
    }

    public List<AddressPrefixItem> destinations() {
        return this.innerProperties() == null ? null : this.innerProperties().destinations();
    }

    public List<String> sourcePortRanges() {
        return this.innerProperties() == null ? null : this.innerProperties().sourcePortRanges();
    }

    public List<String> destinationPortRanges() {
        return this.innerProperties() == null ? null : this.innerProperties().destinationPortRanges();
    }

    public SecurityConfigurationRuleAccess access() {
        return this.innerProperties() == null ? null : this.innerProperties().access();
    }

    public Integer priority() {
        return this.innerProperties() == null ? null : this.innerProperties().priority();
    }

    public SecurityConfigurationRuleDirection direction() {
        return this.innerProperties() == null ? null : this.innerProperties().direction();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.ruleCollectionAppliesToGroups() != null) {
            this.ruleCollectionAppliesToGroups().forEach(e -> e.validate());
        }
        if (this.ruleGroups() != null) {
            this.ruleGroups().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("commitTime", this.commitTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.commitTime()));
        jsonWriter.writeStringField("region", this.region());
        jsonWriter.writeStringField("configurationDescription", this.configurationDescription());
        jsonWriter.writeStringField("ruleCollectionDescription", this.ruleCollectionDescription());
        jsonWriter.writeArrayField("ruleCollectionAppliesToGroups", this.ruleCollectionAppliesToGroups(), (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("ruleGroups", this.ruleGroups(), (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ActiveDefaultSecurityAdminRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ActiveDefaultSecurityAdminRule deserializedActiveDefaultSecurityAdminRule = new ActiveDefaultSecurityAdminRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedActiveDefaultSecurityAdminRule.withId(reader.getString());
                    continue;
                }
                if ("commitTime".equals(fieldName)) {
                    deserializedActiveDefaultSecurityAdminRule.withCommitTime(reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                    continue;
                }
                if ("region".equals(fieldName)) {
                    deserializedActiveDefaultSecurityAdminRule.withRegion(reader.getString());
                    continue;
                }
                if ("configurationDescription".equals(fieldName)) {
                    deserializedActiveDefaultSecurityAdminRule.withConfigurationDescription(reader.getString());
                    continue;
                }
                if ("ruleCollectionDescription".equals(fieldName)) {
                    deserializedActiveDefaultSecurityAdminRule.withRuleCollectionDescription(reader.getString());
                    continue;
                }
                if ("ruleCollectionAppliesToGroups".equals(fieldName)) {
                    List<NetworkManagerSecurityGroupItem> ruleCollectionAppliesToGroups = reader.readArray(reader1 -> NetworkManagerSecurityGroupItem.fromJson(reader1));
                    deserializedActiveDefaultSecurityAdminRule.withRuleCollectionAppliesToGroups((List)ruleCollectionAppliesToGroups);
                    continue;
                }
                if ("ruleGroups".equals(fieldName)) {
                    List<ConfigurationGroup> ruleGroups = reader.readArray(reader1 -> ConfigurationGroup.fromJson(reader1));
                    deserializedActiveDefaultSecurityAdminRule.withRuleGroups((List)ruleGroups);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedActiveDefaultSecurityAdminRule.kind = EffectiveAdminRuleKind.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedActiveDefaultSecurityAdminRule.innerProperties = DefaultAdminPropertiesFormat.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedActiveDefaultSecurityAdminRule;
        });
    }
}

