/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.AzureReachabilityReportLocation;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class AzureReachabilityReportParameters
implements JsonSerializable<AzureReachabilityReportParameters> {
    private AzureReachabilityReportLocation providerLocation;
    private List<String> providers;
    private List<String> azureLocations;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private static final ClientLogger LOGGER = new ClientLogger(AzureReachabilityReportParameters.class);

    public AzureReachabilityReportLocation providerLocation() {
        return this.providerLocation;
    }

    public AzureReachabilityReportParameters withProviderLocation(AzureReachabilityReportLocation providerLocation) {
        this.providerLocation = providerLocation;
        return this;
    }

    public List<String> providers() {
        return this.providers;
    }

    public AzureReachabilityReportParameters withProviders(List<String> providers) {
        this.providers = providers;
        return this;
    }

    public List<String> azureLocations() {
        return this.azureLocations;
    }

    public AzureReachabilityReportParameters withAzureLocations(List<String> azureLocations) {
        this.azureLocations = azureLocations;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public AzureReachabilityReportParameters withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public AzureReachabilityReportParameters withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public void validate() {
        if (this.providerLocation() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property providerLocation in model AzureReachabilityReportParameters"));
        }
        this.providerLocation().validate();
        if (this.startTime() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property startTime in model AzureReachabilityReportParameters"));
        }
        if (this.endTime() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property endTime in model AzureReachabilityReportParameters"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("providerLocation", this.providerLocation);
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeArrayField("providers", this.providers, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("azureLocations", this.azureLocations, (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static AzureReachabilityReportParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureReachabilityReportParameters deserializedAzureReachabilityReportParameters = new AzureReachabilityReportParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("providerLocation".equals(fieldName)) {
                    deserializedAzureReachabilityReportParameters.providerLocation = AzureReachabilityReportLocation.fromJson(reader);
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedAzureReachabilityReportParameters.startTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedAzureReachabilityReportParameters.endTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("providers".equals(fieldName)) {
                    List<String> providers = reader.readArray(reader1 -> reader1.getString());
                    deserializedAzureReachabilityReportParameters.providers = providers;
                    continue;
                }
                if ("azureLocations".equals(fieldName)) {
                    List<String> azureLocations = reader.readArray(reader1 -> reader1.getString());
                    deserializedAzureReachabilityReportParameters.azureLocations = azureLocations;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureReachabilityReportParameters;
        });
    }
}

