/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.HttpConfigurationMethod;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.HttpHeader;
import java.io.IOException;
import java.util.List;

public final class ConnectionMonitorHttpConfiguration
implements JsonSerializable<ConnectionMonitorHttpConfiguration> {
    private Integer port;
    private HttpConfigurationMethod method;
    private String path;
    private List<HttpHeader> requestHeaders;
    private List<String> validStatusCodeRanges;
    private Boolean preferHttps;

    public Integer port() {
        return this.port;
    }

    public ConnectionMonitorHttpConfiguration withPort(Integer port) {
        this.port = port;
        return this;
    }

    public HttpConfigurationMethod method() {
        return this.method;
    }

    public ConnectionMonitorHttpConfiguration withMethod(HttpConfigurationMethod method) {
        this.method = method;
        return this;
    }

    public String path() {
        return this.path;
    }

    public ConnectionMonitorHttpConfiguration withPath(String path) {
        this.path = path;
        return this;
    }

    public List<HttpHeader> requestHeaders() {
        return this.requestHeaders;
    }

    public ConnectionMonitorHttpConfiguration withRequestHeaders(List<HttpHeader> requestHeaders) {
        this.requestHeaders = requestHeaders;
        return this;
    }

    public List<String> validStatusCodeRanges() {
        return this.validStatusCodeRanges;
    }

    public ConnectionMonitorHttpConfiguration withValidStatusCodeRanges(List<String> validStatusCodeRanges) {
        this.validStatusCodeRanges = validStatusCodeRanges;
        return this;
    }

    public Boolean preferHttps() {
        return this.preferHttps;
    }

    public ConnectionMonitorHttpConfiguration withPreferHttps(Boolean preferHttps) {
        this.preferHttps = preferHttps;
        return this;
    }

    public void validate() {
        if (this.requestHeaders() != null) {
            this.requestHeaders().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("port", this.port);
        jsonWriter.writeStringField("method", this.method == null ? null : this.method.toString());
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeArrayField("requestHeaders", this.requestHeaders, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("validStatusCodeRanges", this.validStatusCodeRanges, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeBooleanField("preferHTTPS", this.preferHttps);
        return jsonWriter.writeEndObject();
    }

    public static ConnectionMonitorHttpConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectionMonitorHttpConfiguration deserializedConnectionMonitorHttpConfiguration = new ConnectionMonitorHttpConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("port".equals(fieldName)) {
                    deserializedConnectionMonitorHttpConfiguration.port = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("method".equals(fieldName)) {
                    deserializedConnectionMonitorHttpConfiguration.method = HttpConfigurationMethod.fromString(reader.getString());
                    continue;
                }
                if ("path".equals(fieldName)) {
                    deserializedConnectionMonitorHttpConfiguration.path = reader.getString();
                    continue;
                }
                if ("requestHeaders".equals(fieldName)) {
                    List<HttpHeader> requestHeaders = reader.readArray(reader1 -> HttpHeader.fromJson(reader1));
                    deserializedConnectionMonitorHttpConfiguration.requestHeaders = requestHeaders;
                    continue;
                }
                if ("validStatusCodeRanges".equals(fieldName)) {
                    List<String> validStatusCodeRanges = reader.readArray(reader1 -> reader1.getString());
                    deserializedConnectionMonitorHttpConfiguration.validStatusCodeRanges = validStatusCodeRanges;
                    continue;
                }
                if ("preferHTTPS".equals(fieldName)) {
                    deserializedConnectionMonitorHttpConfiguration.preferHttps = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectionMonitorHttpConfiguration;
        });
    }
}

