/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.MatchVariable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.WebApplicationFirewallOperator;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.WebApplicationFirewallTransform;
import java.io.IOException;
import java.util.List;

public final class MatchCondition
implements JsonSerializable<MatchCondition> {
    private List<MatchVariable> matchVariables;
    private WebApplicationFirewallOperator operator;
    private Boolean negationConditon;
    private List<String> matchValues;
    private List<WebApplicationFirewallTransform> transforms;
    private static final ClientLogger LOGGER = new ClientLogger(MatchCondition.class);

    public List<MatchVariable> matchVariables() {
        return this.matchVariables;
    }

    public MatchCondition withMatchVariables(List<MatchVariable> matchVariables) {
        this.matchVariables = matchVariables;
        return this;
    }

    public WebApplicationFirewallOperator operator() {
        return this.operator;
    }

    public MatchCondition withOperator(WebApplicationFirewallOperator operator) {
        this.operator = operator;
        return this;
    }

    public Boolean negationConditon() {
        return this.negationConditon;
    }

    public MatchCondition withNegationConditon(Boolean negationConditon) {
        this.negationConditon = negationConditon;
        return this;
    }

    public List<String> matchValues() {
        return this.matchValues;
    }

    public MatchCondition withMatchValues(List<String> matchValues) {
        this.matchValues = matchValues;
        return this;
    }

    public List<WebApplicationFirewallTransform> transforms() {
        return this.transforms;
    }

    public MatchCondition withTransforms(List<WebApplicationFirewallTransform> transforms) {
        this.transforms = transforms;
        return this;
    }

    public void validate() {
        if (this.matchVariables() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property matchVariables in model MatchCondition"));
        }
        this.matchVariables().forEach(e -> e.validate());
        if (this.operator() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property operator in model MatchCondition"));
        }
        if (this.matchValues() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property matchValues in model MatchCondition"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("matchVariables", this.matchVariables, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeStringField("operator", this.operator == null ? null : this.operator.toString());
        jsonWriter.writeArrayField("matchValues", this.matchValues, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeBooleanField("negationConditon", this.negationConditon);
        jsonWriter.writeArrayField("transforms", this.transforms, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static MatchCondition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MatchCondition deserializedMatchCondition = new MatchCondition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("matchVariables".equals(fieldName)) {
                    List<MatchVariable> matchVariables = reader.readArray(reader1 -> MatchVariable.fromJson(reader1));
                    deserializedMatchCondition.matchVariables = matchVariables;
                    continue;
                }
                if ("operator".equals(fieldName)) {
                    deserializedMatchCondition.operator = WebApplicationFirewallOperator.fromString(reader.getString());
                    continue;
                }
                if ("matchValues".equals(fieldName)) {
                    List<String> matchValues = reader.readArray(reader1 -> reader1.getString());
                    deserializedMatchCondition.matchValues = matchValues;
                    continue;
                }
                if ("negationConditon".equals(fieldName)) {
                    deserializedMatchCondition.negationConditon = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("transforms".equals(fieldName)) {
                    List<WebApplicationFirewallTransform> transforms = reader.readArray(reader1 -> WebApplicationFirewallTransform.fromString(reader1.getString()));
                    deserializedMatchCondition.transforms = transforms;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMatchCondition;
        });
    }
}

