/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.AddressSpace;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.IpsecPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.RadiusServer;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.VngClientConnectionConfiguration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.VpnAuthenticationType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.VpnClientProtocol;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.VpnClientRevokedCertificate;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.VpnClientRootCertificate;
import java.io.IOException;
import java.util.List;

public final class VpnClientConfiguration
implements JsonSerializable<VpnClientConfiguration> {
    private AddressSpace vpnClientAddressPool;
    private List<VpnClientRootCertificate> vpnClientRootCertificates;
    private List<VpnClientRevokedCertificate> vpnClientRevokedCertificates;
    private List<VpnClientProtocol> vpnClientProtocols;
    private List<VpnAuthenticationType> vpnAuthenticationTypes;
    private List<IpsecPolicy> vpnClientIpsecPolicies;
    private String radiusServerAddress;
    private String radiusServerSecret;
    private List<RadiusServer> radiusServers;
    private String aadTenant;
    private String aadAudience;
    private String aadIssuer;
    private List<VngClientConnectionConfiguration> vngClientConnectionConfigurations;

    public AddressSpace vpnClientAddressPool() {
        return this.vpnClientAddressPool;
    }

    public VpnClientConfiguration withVpnClientAddressPool(AddressSpace vpnClientAddressPool) {
        this.vpnClientAddressPool = vpnClientAddressPool;
        return this;
    }

    public List<VpnClientRootCertificate> vpnClientRootCertificates() {
        return this.vpnClientRootCertificates;
    }

    public VpnClientConfiguration withVpnClientRootCertificates(List<VpnClientRootCertificate> vpnClientRootCertificates) {
        this.vpnClientRootCertificates = vpnClientRootCertificates;
        return this;
    }

    public List<VpnClientRevokedCertificate> vpnClientRevokedCertificates() {
        return this.vpnClientRevokedCertificates;
    }

    public VpnClientConfiguration withVpnClientRevokedCertificates(List<VpnClientRevokedCertificate> vpnClientRevokedCertificates) {
        this.vpnClientRevokedCertificates = vpnClientRevokedCertificates;
        return this;
    }

    public List<VpnClientProtocol> vpnClientProtocols() {
        return this.vpnClientProtocols;
    }

    public VpnClientConfiguration withVpnClientProtocols(List<VpnClientProtocol> vpnClientProtocols) {
        this.vpnClientProtocols = vpnClientProtocols;
        return this;
    }

    public List<VpnAuthenticationType> vpnAuthenticationTypes() {
        return this.vpnAuthenticationTypes;
    }

    public VpnClientConfiguration withVpnAuthenticationTypes(List<VpnAuthenticationType> vpnAuthenticationTypes) {
        this.vpnAuthenticationTypes = vpnAuthenticationTypes;
        return this;
    }

    public List<IpsecPolicy> vpnClientIpsecPolicies() {
        return this.vpnClientIpsecPolicies;
    }

    public VpnClientConfiguration withVpnClientIpsecPolicies(List<IpsecPolicy> vpnClientIpsecPolicies) {
        this.vpnClientIpsecPolicies = vpnClientIpsecPolicies;
        return this;
    }

    public String radiusServerAddress() {
        return this.radiusServerAddress;
    }

    public VpnClientConfiguration withRadiusServerAddress(String radiusServerAddress) {
        this.radiusServerAddress = radiusServerAddress;
        return this;
    }

    public String radiusServerSecret() {
        return this.radiusServerSecret;
    }

    public VpnClientConfiguration withRadiusServerSecret(String radiusServerSecret) {
        this.radiusServerSecret = radiusServerSecret;
        return this;
    }

    public List<RadiusServer> radiusServers() {
        return this.radiusServers;
    }

    public VpnClientConfiguration withRadiusServers(List<RadiusServer> radiusServers) {
        this.radiusServers = radiusServers;
        return this;
    }

    public String aadTenant() {
        return this.aadTenant;
    }

    public VpnClientConfiguration withAadTenant(String aadTenant) {
        this.aadTenant = aadTenant;
        return this;
    }

    public String aadAudience() {
        return this.aadAudience;
    }

    public VpnClientConfiguration withAadAudience(String aadAudience) {
        this.aadAudience = aadAudience;
        return this;
    }

    public String aadIssuer() {
        return this.aadIssuer;
    }

    public VpnClientConfiguration withAadIssuer(String aadIssuer) {
        this.aadIssuer = aadIssuer;
        return this;
    }

    public List<VngClientConnectionConfiguration> vngClientConnectionConfigurations() {
        return this.vngClientConnectionConfigurations;
    }

    public VpnClientConfiguration withVngClientConnectionConfigurations(List<VngClientConnectionConfiguration> vngClientConnectionConfigurations) {
        this.vngClientConnectionConfigurations = vngClientConnectionConfigurations;
        return this;
    }

    public void validate() {
        if (this.vpnClientAddressPool() != null) {
            this.vpnClientAddressPool().validate();
        }
        if (this.vpnClientRootCertificates() != null) {
            this.vpnClientRootCertificates().forEach(e -> e.validate());
        }
        if (this.vpnClientRevokedCertificates() != null) {
            this.vpnClientRevokedCertificates().forEach(e -> e.validate());
        }
        if (this.vpnClientIpsecPolicies() != null) {
            this.vpnClientIpsecPolicies().forEach(e -> e.validate());
        }
        if (this.radiusServers() != null) {
            this.radiusServers().forEach(e -> e.validate());
        }
        if (this.vngClientConnectionConfigurations() != null) {
            this.vngClientConnectionConfigurations().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("vpnClientAddressPool", this.vpnClientAddressPool);
        jsonWriter.writeArrayField("vpnClientRootCertificates", this.vpnClientRootCertificates, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("vpnClientRevokedCertificates", this.vpnClientRevokedCertificates, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("vpnClientProtocols", this.vpnClientProtocols, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("vpnAuthenticationTypes", this.vpnAuthenticationTypes, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("vpnClientIpsecPolicies", this.vpnClientIpsecPolicies, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeStringField("radiusServerAddress", this.radiusServerAddress);
        jsonWriter.writeStringField("radiusServerSecret", this.radiusServerSecret);
        jsonWriter.writeArrayField("radiusServers", this.radiusServers, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeStringField("aadTenant", this.aadTenant);
        jsonWriter.writeStringField("aadAudience", this.aadAudience);
        jsonWriter.writeStringField("aadIssuer", this.aadIssuer);
        jsonWriter.writeArrayField("vngClientConnectionConfigurations", this.vngClientConnectionConfigurations, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static VpnClientConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VpnClientConfiguration deserializedVpnClientConfiguration = new VpnClientConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("vpnClientAddressPool".equals(fieldName)) {
                    deserializedVpnClientConfiguration.vpnClientAddressPool = AddressSpace.fromJson(reader);
                    continue;
                }
                if ("vpnClientRootCertificates".equals(fieldName)) {
                    List<VpnClientRootCertificate> vpnClientRootCertificates = reader.readArray(reader1 -> VpnClientRootCertificate.fromJson(reader1));
                    deserializedVpnClientConfiguration.vpnClientRootCertificates = vpnClientRootCertificates;
                    continue;
                }
                if ("vpnClientRevokedCertificates".equals(fieldName)) {
                    List<VpnClientRevokedCertificate> vpnClientRevokedCertificates = reader.readArray(reader1 -> VpnClientRevokedCertificate.fromJson(reader1));
                    deserializedVpnClientConfiguration.vpnClientRevokedCertificates = vpnClientRevokedCertificates;
                    continue;
                }
                if ("vpnClientProtocols".equals(fieldName)) {
                    List<VpnClientProtocol> vpnClientProtocols = reader.readArray(reader1 -> VpnClientProtocol.fromString(reader1.getString()));
                    deserializedVpnClientConfiguration.vpnClientProtocols = vpnClientProtocols;
                    continue;
                }
                if ("vpnAuthenticationTypes".equals(fieldName)) {
                    List<VpnAuthenticationType> vpnAuthenticationTypes = reader.readArray(reader1 -> VpnAuthenticationType.fromString(reader1.getString()));
                    deserializedVpnClientConfiguration.vpnAuthenticationTypes = vpnAuthenticationTypes;
                    continue;
                }
                if ("vpnClientIpsecPolicies".equals(fieldName)) {
                    List<IpsecPolicy> vpnClientIpsecPolicies = reader.readArray(reader1 -> IpsecPolicy.fromJson(reader1));
                    deserializedVpnClientConfiguration.vpnClientIpsecPolicies = vpnClientIpsecPolicies;
                    continue;
                }
                if ("radiusServerAddress".equals(fieldName)) {
                    deserializedVpnClientConfiguration.radiusServerAddress = reader.getString();
                    continue;
                }
                if ("radiusServerSecret".equals(fieldName)) {
                    deserializedVpnClientConfiguration.radiusServerSecret = reader.getString();
                    continue;
                }
                if ("radiusServers".equals(fieldName)) {
                    List<RadiusServer> radiusServers = reader.readArray(reader1 -> RadiusServer.fromJson(reader1));
                    deserializedVpnClientConfiguration.radiusServers = radiusServers;
                    continue;
                }
                if ("aadTenant".equals(fieldName)) {
                    deserializedVpnClientConfiguration.aadTenant = reader.getString();
                    continue;
                }
                if ("aadAudience".equals(fieldName)) {
                    deserializedVpnClientConfiguration.aadAudience = reader.getString();
                    continue;
                }
                if ("aadIssuer".equals(fieldName)) {
                    deserializedVpnClientConfiguration.aadIssuer = reader.getString();
                    continue;
                }
                if ("vngClientConnectionConfigurations".equals(fieldName)) {
                    List<VngClientConnectionConfiguration> vngClientConnectionConfigurations = reader.readArray(reader1 -> VngClientConnectionConfiguration.fromJson(reader1));
                    deserializedVpnClientConfiguration.vngClientConnectionConfigurations = vngClientConnectionConfigurations;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVpnClientConfiguration;
        });
    }
}

