/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.policy;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeader;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaders;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineCallContext;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineNextPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpRequest;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpPipelinePolicy;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class ReturnRequestIdHeaderPolicy
implements HttpPipelinePolicy {
    private static final String NAME_RETURN_CLIENT_REQUEST_ID = "x-ms-return-client-request-id";
    private static final String NAME_CLIENT_REQUEST_ID = "x-ms-client-request-id";
    private final Option option;

    public ReturnRequestIdHeaderPolicy() {
        this(Option.NONE);
    }

    public ReturnRequestIdHeaderPolicy(Option option) {
        this.option = option;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        HttpRequest request = context.getHttpRequest();
        String clientRequestId = request.getHeaders().getValue(NAME_CLIENT_REQUEST_ID);
        if (request.getHeaders().getValue(NAME_RETURN_CLIENT_REQUEST_ID) == null) {
            request.getHeaders().set(NAME_RETURN_CLIENT_REQUEST_ID, "true");
        }
        Mono<HttpResponse> responseMono = next.process();
        if (this.option == Option.COPY_CLIENT_REQUEST_ID && clientRequestId != null) {
            responseMono = responseMono.map(response -> {
                if (response.getHeaderValue(NAME_CLIENT_REQUEST_ID) == null) {
                    response = new BufferedHttpHeaderResponse((HttpResponse)response);
                    response.getHeaders().set(NAME_CLIENT_REQUEST_ID, clientRequestId);
                }
                return response;
            });
        }
        return responseMono;
    }

    public static enum Option {
        NONE,
        COPY_CLIENT_REQUEST_ID;

    }

    private static class BufferedHttpHeaderResponse
    extends HttpResponse {
        private final HttpResponse innerHttpResponse;
        private final HttpHeaders cachedHeaders;

        BufferedHttpHeaderResponse(HttpResponse innerHttpResponse) {
            super(innerHttpResponse.getRequest());
            this.innerHttpResponse = innerHttpResponse;
            this.cachedHeaders = new HttpHeaders((Iterable<HttpHeader>)innerHttpResponse.getHeaders());
        }

        @Override
        public int getStatusCode() {
            return this.innerHttpResponse.getStatusCode();
        }

        @Override
        public String getHeaderValue(String name) {
            return this.cachedHeaders.getValue(name);
        }

        @Override
        public HttpHeaders getHeaders() {
            return this.cachedHeaders;
        }

        @Override
        public Flux<ByteBuffer> getBody() {
            return this.innerHttpResponse.getBody();
        }

        @Override
        public Mono<byte[]> getBodyAsByteArray() {
            return this.innerHttpResponse.getBodyAsByteArray();
        }

        @Override
        public Mono<String> getBodyAsString() {
            return this.innerHttpResponse.getBodyAsString();
        }

        @Override
        public Mono<String> getBodyAsString(Charset charset) {
            return this.innerHttpResponse.getBodyAsString();
        }
    }
}

