/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.BodyParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Post;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluent.SubscriptionsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluent.models.CheckZonePeersResultInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluent.models.LocationInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluent.models.SubscriptionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.implementation.SubscriptionClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.CheckZonePeersRequest;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.LocationListResult;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.SubscriptionListResult;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class SubscriptionsClientImpl
implements SubscriptionsClient {
    private final SubscriptionsService service;
    private final SubscriptionClientImpl client;

    SubscriptionsClientImpl(SubscriptionClientImpl client) {
        this.service = RestProxy.create(SubscriptionsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LocationInner>> listLocationsSinglePageAsync(String subscriptionId, Boolean includeExtendedLocations) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listLocations(this.client.getEndpoint(), subscriptionId, this.client.getApiVersion(), includeExtendedLocations, "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, LocationInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LocationListResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LocationInner>> listLocationsSinglePageAsync(String subscriptionId, Boolean includeExtendedLocations, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listLocations(this.client.getEndpoint(), subscriptionId, this.client.getApiVersion(), includeExtendedLocations, "application/json", context).map(res -> new PagedResponseBase<Object, LocationInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LocationListResult)res.getValue()).value(), null, null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<LocationInner> listLocationsAsync(String subscriptionId, Boolean includeExtendedLocations) {
        return new PagedFlux<LocationInner>(() -> this.listLocationsSinglePageAsync(subscriptionId, includeExtendedLocations));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<LocationInner> listLocationsAsync(String subscriptionId) {
        Boolean includeExtendedLocations = null;
        return new PagedFlux<LocationInner>(() -> this.listLocationsSinglePageAsync(subscriptionId, includeExtendedLocations));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<LocationInner> listLocationsAsync(String subscriptionId, Boolean includeExtendedLocations, Context context) {
        return new PagedFlux<LocationInner>(() -> this.listLocationsSinglePageAsync(subscriptionId, includeExtendedLocations, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LocationInner> listLocations(String subscriptionId) {
        Boolean includeExtendedLocations = null;
        return new PagedIterable<LocationInner>(this.listLocationsAsync(subscriptionId, includeExtendedLocations));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LocationInner> listLocations(String subscriptionId, Boolean includeExtendedLocations, Context context) {
        return new PagedIterable<LocationInner>(this.listLocationsAsync(subscriptionId, includeExtendedLocations, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SubscriptionInner>> getWithResponseAsync(String subscriptionId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), subscriptionId, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SubscriptionInner>> getWithResponseAsync(String subscriptionId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), subscriptionId, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SubscriptionInner> getAsync(String subscriptionId) {
        return this.getWithResponseAsync(subscriptionId).flatMap(res -> Mono.justOrEmpty((SubscriptionInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SubscriptionInner> getWithResponse(String subscriptionId, Context context) {
        return this.getWithResponseAsync(subscriptionId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SubscriptionInner get(String subscriptionId) {
        return this.getWithResponse(subscriptionId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SubscriptionInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, SubscriptionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SubscriptionListResult)res.getValue()).value(), ((SubscriptionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SubscriptionInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase<Object, SubscriptionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SubscriptionListResult)res.getValue()).value(), ((SubscriptionListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SubscriptionInner> listAsync() {
        return new PagedFlux<SubscriptionInner>(() -> this.listSinglePageAsync(), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SubscriptionInner> listAsync(Context context) {
        return new PagedFlux<SubscriptionInner>(() -> this.listSinglePageAsync(context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SubscriptionInner> list() {
        return new PagedIterable<SubscriptionInner>(this.listAsync());
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SubscriptionInner> list(Context context) {
        return new PagedIterable<SubscriptionInner>(this.listAsync(context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CheckZonePeersResultInner>> checkZonePeersWithResponseAsync(String subscriptionId, CheckZonePeersRequest parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkZonePeers(this.client.getEndpoint(), subscriptionId, this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CheckZonePeersResultInner>> checkZonePeersWithResponseAsync(String subscriptionId, CheckZonePeersRequest parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkZonePeers(this.client.getEndpoint(), subscriptionId, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CheckZonePeersResultInner> checkZonePeersAsync(String subscriptionId, CheckZonePeersRequest parameters) {
        return this.checkZonePeersWithResponseAsync(subscriptionId, parameters).flatMap(res -> Mono.justOrEmpty((CheckZonePeersResultInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CheckZonePeersResultInner> checkZonePeersWithResponse(String subscriptionId, CheckZonePeersRequest parameters, Context context) {
        return this.checkZonePeersWithResponseAsync(subscriptionId, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CheckZonePeersResultInner checkZonePeers(String subscriptionId, CheckZonePeersRequest parameters) {
        return this.checkZonePeersWithResponse(subscriptionId, parameters, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SubscriptionInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, SubscriptionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SubscriptionListResult)res.getValue()).value(), ((SubscriptionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SubscriptionInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, SubscriptionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SubscriptionListResult)res.getValue()).value(), ((SubscriptionListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SubscriptionClientSu")
    public static interface SubscriptionsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/locations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LocationListResult>> listLocations(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @QueryParam(value="includeExtendedLocations") Boolean var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SubscriptionInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SubscriptionListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Resources/checkZonePeers/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CheckZonePeersResultInner>> checkZonePeers(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CheckZonePeersRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SubscriptionListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

