/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.AliasPathMetadata;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.AliasPattern;
import java.io.IOException;
import java.util.List;

public final class AliasPath
implements JsonSerializable<AliasPath> {
    private String path;
    private List<String> apiVersions;
    private AliasPattern pattern;
    private AliasPathMetadata metadata;

    public String path() {
        return this.path;
    }

    public AliasPath withPath(String path) {
        this.path = path;
        return this;
    }

    public List<String> apiVersions() {
        return this.apiVersions;
    }

    public AliasPath withApiVersions(List<String> apiVersions) {
        this.apiVersions = apiVersions;
        return this;
    }

    public AliasPattern pattern() {
        return this.pattern;
    }

    public AliasPath withPattern(AliasPattern pattern) {
        this.pattern = pattern;
        return this;
    }

    public AliasPathMetadata metadata() {
        return this.metadata;
    }

    public void validate() {
        if (this.pattern() != null) {
            this.pattern().validate();
        }
        if (this.metadata() != null) {
            this.metadata().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeArrayField("apiVersions", this.apiVersions, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("pattern", this.pattern);
        return jsonWriter.writeEndObject();
    }

    public static AliasPath fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AliasPath deserializedAliasPath = new AliasPath();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("path".equals(fieldName)) {
                    deserializedAliasPath.path = reader.getString();
                    continue;
                }
                if ("apiVersions".equals(fieldName)) {
                    List<String> apiVersions = reader.readArray(reader1 -> reader1.getString());
                    deserializedAliasPath.apiVersions = apiVersions;
                    continue;
                }
                if ("pattern".equals(fieldName)) {
                    deserializedAliasPath.pattern = AliasPattern.fromJson(reader);
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    deserializedAliasPath.metadata = AliasPathMetadata.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAliasPath;
        });
    }
}

