/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.HttpMessage;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.ProvisioningOperation;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.StatusMessage;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.TargetResource;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class DeploymentOperationProperties
implements JsonSerializable<DeploymentOperationProperties> {
    private ProvisioningOperation provisioningOperation;
    private String provisioningState;
    private OffsetDateTime timestamp;
    private String duration;
    private String serviceRequestId;
    private String statusCode;
    private StatusMessage statusMessage;
    private TargetResource targetResource;
    private HttpMessage request;
    private HttpMessage response;

    public ProvisioningOperation provisioningOperation() {
        return this.provisioningOperation;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    public String duration() {
        return this.duration;
    }

    public String serviceRequestId() {
        return this.serviceRequestId;
    }

    public String statusCode() {
        return this.statusCode;
    }

    public StatusMessage statusMessage() {
        return this.statusMessage;
    }

    public TargetResource targetResource() {
        return this.targetResource;
    }

    public HttpMessage request() {
        return this.request;
    }

    public HttpMessage response() {
        return this.response;
    }

    public void validate() {
        if (this.statusMessage() != null) {
            this.statusMessage().validate();
        }
        if (this.targetResource() != null) {
            this.targetResource().validate();
        }
        if (this.request() != null) {
            this.request().validate();
        }
        if (this.response() != null) {
            this.response().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static DeploymentOperationProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeploymentOperationProperties deserializedDeploymentOperationProperties = new DeploymentOperationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningOperation".equals(fieldName)) {
                    deserializedDeploymentOperationProperties.provisioningOperation = ProvisioningOperation.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDeploymentOperationProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("timestamp".equals(fieldName)) {
                    deserializedDeploymentOperationProperties.timestamp = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("duration".equals(fieldName)) {
                    deserializedDeploymentOperationProperties.duration = reader.getString();
                    continue;
                }
                if ("serviceRequestId".equals(fieldName)) {
                    deserializedDeploymentOperationProperties.serviceRequestId = reader.getString();
                    continue;
                }
                if ("statusCode".equals(fieldName)) {
                    deserializedDeploymentOperationProperties.statusCode = reader.getString();
                    continue;
                }
                if ("statusMessage".equals(fieldName)) {
                    deserializedDeploymentOperationProperties.statusMessage = StatusMessage.fromJson(reader);
                    continue;
                }
                if ("targetResource".equals(fieldName)) {
                    deserializedDeploymentOperationProperties.targetResource = TargetResource.fromJson(reader);
                    continue;
                }
                if ("request".equals(fieldName)) {
                    deserializedDeploymentOperationProperties.request = HttpMessage.fromJson(reader);
                    continue;
                }
                if ("response".equals(fieldName)) {
                    deserializedDeploymentOperationProperties.response = HttpMessage.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeploymentOperationProperties;
        });
    }
}

