/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.implementation;

import java.time.Duration;

public final class DurationSerializer {
    public static String serialize(Duration duration) {
        String result = null;
        if (duration != null) {
            if (duration.isZero()) {
                result = "PT0S";
            } else {
                long nanoseconds;
                long seconds;
                long minutes;
                long hours;
                StringBuilder builder = new StringBuilder();
                builder.append('P');
                long days = duration.toDays();
                if (days > 0L) {
                    builder.append(days);
                    builder.append('D');
                    duration = duration.minusDays(days);
                }
                if ((hours = duration.toHours()) > 0L) {
                    builder.append('T');
                    builder.append(hours);
                    builder.append('H');
                    duration = duration.minusHours(hours);
                }
                if ((minutes = duration.toMinutes()) > 0L) {
                    if (hours == 0L) {
                        builder.append('T');
                    }
                    builder.append(minutes);
                    builder.append('M');
                    duration = duration.minusMinutes(minutes);
                }
                if ((seconds = duration.getSeconds()) > 0L) {
                    if (hours == 0L && minutes == 0L) {
                        builder.append('T');
                    }
                    builder.append(seconds);
                    duration = duration.minusSeconds(seconds);
                }
                if ((nanoseconds = (long)duration.getNano()) > 0L) {
                    if (hours == 0L && minutes == 0L && seconds == 0L) {
                        builder.append("T");
                    }
                    if (seconds == 0L) {
                        builder.append("0");
                    }
                    builder.append('.');
                    for (long nanoMax = 100000000L; nanoseconds < nanoMax; nanoMax /= 10L) {
                        builder.append('0');
                    }
                    while (nanoseconds % 10L == 0L) {
                        nanoseconds /= 10L;
                    }
                    builder.append(nanoseconds);
                }
                if (seconds > 0L || nanoseconds > 0L) {
                    builder.append('S');
                }
                result = builder.toString();
            }
        }
        return result;
    }
}

