/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.ServiceBusManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.fluent.ServiceBusManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.fluent.models.SBNamespaceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.implementation.NamespaceAuthorizationRulesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.implementation.QueuesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.implementation.TopicsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.models.NamespaceAuthorizationRule;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.models.NamespaceSku;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.models.Queue;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.models.SBSku;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.models.ServiceBusNamespace;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.models.Topic;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;

class ServiceBusNamespaceImpl
extends GroupableResourceImpl<ServiceBusNamespace, SBNamespaceInner, ServiceBusNamespaceImpl, ServiceBusManager>
implements ServiceBusNamespace,
ServiceBusNamespace.Definition,
ServiceBusNamespace.Update {
    private List<Creatable<Queue>> queuesToCreate;
    private List<Creatable<Topic>> topicsToCreate;
    private List<Creatable<NamespaceAuthorizationRule>> rulesToCreate;
    private List<String> queuesToDelete;
    private List<String> topicsToDelete;
    private List<String> rulesToDelete;

    ServiceBusNamespaceImpl(String name, SBNamespaceInner inner, ServiceBusManager manager) {
        super(name, inner, manager);
        this.initChildrenOperationsCache();
    }

    @Override
    public String dnsLabel() {
        return ((SBNamespaceInner)this.innerModel()).name();
    }

    @Override
    public String fqdn() {
        return ((SBNamespaceInner)this.innerModel()).serviceBusEndpoint();
    }

    @Override
    public NamespaceSku sku() {
        return new NamespaceSku(((SBNamespaceInner)this.innerModel()).sku());
    }

    @Override
    public OffsetDateTime createdAt() {
        return ((SBNamespaceInner)this.innerModel()).createdAt();
    }

    @Override
    public OffsetDateTime updatedAt() {
        return ((SBNamespaceInner)this.innerModel()).updatedAt();
    }

    @Override
    public QueuesImpl queues() {
        return new QueuesImpl(this.resourceGroupName(), this.name(), this.region(), (ServiceBusManager)this.manager());
    }

    @Override
    public TopicsImpl topics() {
        return new TopicsImpl(this.resourceGroupName(), this.name(), this.region(), (ServiceBusManager)this.manager());
    }

    @Override
    public NamespaceAuthorizationRulesImpl authorizationRules() {
        return new NamespaceAuthorizationRulesImpl(this.resourceGroupName(), this.name(), this.region(), (ServiceBusManager)this.manager());
    }

    @Override
    public ServiceBusNamespaceImpl withSku(NamespaceSku namespaceSku) {
        ((SBNamespaceInner)this.innerModel()).withSku(new SBSku().withName(namespaceSku.name()).withTier(namespaceSku.tier()).withCapacity(namespaceSku.capacity()));
        return this;
    }

    @Override
    public ServiceBusNamespaceImpl withNewQueue(String name, int maxSizeInMB) {
        this.queuesToCreate.add(this.queues().define(name).withSizeInMB(maxSizeInMB));
        return this;
    }

    @Override
    public ServiceBusNamespaceImpl withoutQueue(String name) {
        this.queuesToDelete.add(name);
        return this;
    }

    @Override
    public ServiceBusNamespaceImpl withNewTopic(String name, int maxSizeInMB) {
        this.topicsToCreate.add(this.topics().define(name).withSizeInMB(maxSizeInMB));
        return this;
    }

    @Override
    public ServiceBusNamespaceImpl withoutTopic(String name) {
        this.topicsToDelete.add(name);
        return this;
    }

    @Override
    public ServiceBusNamespaceImpl withNewSendRule(String name) {
        this.rulesToCreate.add((Creatable<NamespaceAuthorizationRule>)this.authorizationRules().define(name).withSendingEnabled());
        return this;
    }

    @Override
    public ServiceBusNamespaceImpl withNewListenRule(String name) {
        this.rulesToCreate.add((Creatable<NamespaceAuthorizationRule>)this.authorizationRules().define(name).withListeningEnabled());
        return this;
    }

    @Override
    public ServiceBusNamespaceImpl withNewManageRule(String name) {
        this.rulesToCreate.add((Creatable<NamespaceAuthorizationRule>)this.authorizationRules().define(name).withManagementEnabled());
        return this;
    }

    @Override
    public ServiceBusNamespaceImpl withoutAuthorizationRule(String name) {
        this.rulesToDelete.add(name);
        return this;
    }

    @Override
    protected Mono<SBNamespaceInner> getInnerAsync() {
        return ((ServiceBusManagementClient)((ServiceBusManager)this.manager()).serviceClient()).getNamespaces().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public Mono<ServiceBusNamespace> createResourceAsync() {
        Mono<SBNamespaceInner> createTask = ((ServiceBusManagementClient)((ServiceBusManager)this.manager()).serviceClient()).getNamespaces().createOrUpdateAsync(this.resourceGroupName(), this.name(), (SBNamespaceInner)this.innerModel()).map(inner -> {
            this.setInner(inner);
            return inner;
        });
        Flux<Void> childOperationTasks = this.submitChildrenOperationsAsync();
        ServiceBusNamespaceImpl self = this;
        return Flux.concat(createTask, childOperationTasks).doOnTerminate(() -> this.initChildrenOperationsCache()).then(Mono.just(self));
    }

    private void initChildrenOperationsCache() {
        this.queuesToCreate = new ArrayList<Creatable<Queue>>();
        this.topicsToCreate = new ArrayList<Creatable<Topic>>();
        this.rulesToCreate = new ArrayList<Creatable<NamespaceAuthorizationRule>>();
        this.queuesToDelete = new ArrayList<String>();
        this.topicsToDelete = new ArrayList<String>();
        this.rulesToDelete = new ArrayList<String>();
    }

    private Flux<Void> submitChildrenOperationsAsync() {
        Flux<Object> queuesCreateStream = Flux.empty();
        if (this.queuesToCreate.size() > 0) {
            queuesCreateStream = this.queues().createAsync(this.queuesToCreate).then().flux();
        }
        Flux<Object> topicsCreateStream = Flux.empty();
        if (this.topicsToCreate.size() > 0) {
            topicsCreateStream = this.topics().createAsync(this.topicsToCreate).then().flux();
        }
        Flux<Object> rulesCreateStream = Flux.empty();
        if (this.rulesToCreate.size() > 0) {
            rulesCreateStream = this.authorizationRules().createAsync(this.rulesToCreate).then().flux();
        }
        Flux<Object> queuesDeleteStream = Flux.empty();
        if (this.queuesToDelete.size() > 0) {
            queuesDeleteStream = this.queues().deleteByNameAsync(this.queuesToDelete);
        }
        Flux<Object> topicsDeleteStream = Flux.empty();
        if (this.topicsToDelete.size() > 0) {
            topicsDeleteStream = this.topics().deleteByNameAsync(this.topicsToDelete);
        }
        Flux<Object> rulesDeleteStream = Flux.empty();
        if (this.rulesToDelete.size() > 0) {
            rulesDeleteStream = this.authorizationRules().deleteByNameAsync(this.rulesToDelete);
        }
        return Flux.mergeDelayError(32, queuesCreateStream, topicsCreateStream, rulesCreateStream, queuesDeleteStream, topicsDeleteStream, rulesDeleteStream);
    }
}

