/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.management.Region;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.ServiceBusManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.fluent.ServiceBusManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.fluent.SubscriptionsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.fluent.models.SBSubscriptionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.implementation.ServiceBusChildResourcesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.implementation.ServiceBusSubscriptionImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.models.ServiceBusSubscription;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.models.ServiceBusSubscriptions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.models.Topic;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

class ServiceBusSubscriptionsImpl
extends ServiceBusChildResourcesImpl<ServiceBusSubscription, ServiceBusSubscriptionImpl, SBSubscriptionInner, SubscriptionsClient, ServiceBusManager, Topic>
implements ServiceBusSubscriptions {
    private final String resourceGroupName;
    private final String namespaceName;
    private final String topicName;
    private final Region region;
    private final ClientLogger logger = new ClientLogger(ServiceBusSubscriptionsImpl.class);

    protected ServiceBusSubscriptionsImpl(String resourceGroupName, String namespaceName, String topicName, Region region, ServiceBusManager manager) {
        super(((ServiceBusManagementClient)manager.serviceClient()).getSubscriptions(), manager);
        this.resourceGroupName = resourceGroupName;
        this.namespaceName = namespaceName;
        this.topicName = topicName;
        this.region = region;
    }

    @Override
    public ServiceBusSubscriptionImpl define(String name) {
        return this.wrapModel(name);
    }

    @Override
    public Mono<Void> deleteByNameAsync(String name) {
        return ((SubscriptionsClient)this.innerModel()).deleteAsync(this.resourceGroupName, this.namespaceName, this.topicName, name);
    }

    @Override
    protected Mono<SBSubscriptionInner> getInnerByNameAsync(String name) {
        return ((SubscriptionsClient)this.innerModel()).getAsync(this.resourceGroupName, this.namespaceName, this.topicName, name);
    }

    @Override
    protected PagedFlux<SBSubscriptionInner> listInnerAsync() {
        return ((SubscriptionsClient)this.innerModel()).listByTopicAsync(this.resourceGroupName, this.namespaceName, this.topicName);
    }

    @Override
    protected PagedIterable<SBSubscriptionInner> listInner() {
        return ((SubscriptionsClient)this.innerModel()).listByTopic(this.resourceGroupName, this.namespaceName, this.topicName);
    }

    @Override
    protected ServiceBusSubscriptionImpl wrapModel(String name) {
        return new ServiceBusSubscriptionImpl(this.resourceGroupName, this.namespaceName, this.topicName, name, new SBSubscriptionInner(), (ServiceBusManager)this.manager());
    }

    @Override
    protected ServiceBusSubscriptionImpl wrapModel(SBSubscriptionInner inner) {
        return new ServiceBusSubscriptionImpl(this.resourceGroupName, this.namespaceName, this.topicName, inner.name(), inner, (ServiceBusManager)this.manager());
    }

    @Override
    public PagedIterable<ServiceBusSubscription> listByParent(String resourceGroupName, String parentName) {
        throw this.logger.logExceptionAsError(new UnsupportedOperationException());
    }

    @Override
    public Mono<Void> deleteByParentAsync(String groupName, String parentName, String name) {
        throw this.logger.logExceptionAsError(new UnsupportedOperationException());
    }

    @Override
    public Mono<ServiceBusSubscription> getByParentAsync(String resourceGroup, String parentName, String name) {
        throw this.logger.logExceptionAsError(new UnsupportedOperationException());
    }
}

