/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.DataMaskingFunction;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.DataMaskingRuleState;
import java.io.IOException;

public final class DataMaskingRuleProperties
implements JsonSerializable<DataMaskingRuleProperties> {
    private String id;
    private DataMaskingRuleState ruleState;
    private String schemaName;
    private String tableName;
    private String columnName;
    private String aliasName;
    private DataMaskingFunction maskingFunction;
    private String numberFrom;
    private String numberTo;
    private String prefixSize;
    private String suffixSize;
    private String replacementString;
    private static final ClientLogger LOGGER = new ClientLogger(DataMaskingRuleProperties.class);

    public String id() {
        return this.id;
    }

    public DataMaskingRuleState ruleState() {
        return this.ruleState;
    }

    public DataMaskingRuleProperties withRuleState(DataMaskingRuleState ruleState) {
        this.ruleState = ruleState;
        return this;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public DataMaskingRuleProperties withSchemaName(String schemaName) {
        this.schemaName = schemaName;
        return this;
    }

    public String tableName() {
        return this.tableName;
    }

    public DataMaskingRuleProperties withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public String columnName() {
        return this.columnName;
    }

    public DataMaskingRuleProperties withColumnName(String columnName) {
        this.columnName = columnName;
        return this;
    }

    public String aliasName() {
        return this.aliasName;
    }

    public DataMaskingRuleProperties withAliasName(String aliasName) {
        this.aliasName = aliasName;
        return this;
    }

    public DataMaskingFunction maskingFunction() {
        return this.maskingFunction;
    }

    public DataMaskingRuleProperties withMaskingFunction(DataMaskingFunction maskingFunction) {
        this.maskingFunction = maskingFunction;
        return this;
    }

    public String numberFrom() {
        return this.numberFrom;
    }

    public DataMaskingRuleProperties withNumberFrom(String numberFrom) {
        this.numberFrom = numberFrom;
        return this;
    }

    public String numberTo() {
        return this.numberTo;
    }

    public DataMaskingRuleProperties withNumberTo(String numberTo) {
        this.numberTo = numberTo;
        return this;
    }

    public String prefixSize() {
        return this.prefixSize;
    }

    public DataMaskingRuleProperties withPrefixSize(String prefixSize) {
        this.prefixSize = prefixSize;
        return this;
    }

    public String suffixSize() {
        return this.suffixSize;
    }

    public DataMaskingRuleProperties withSuffixSize(String suffixSize) {
        this.suffixSize = suffixSize;
        return this;
    }

    public String replacementString() {
        return this.replacementString;
    }

    public DataMaskingRuleProperties withReplacementString(String replacementString) {
        this.replacementString = replacementString;
        return this;
    }

    public void validate() {
        if (this.schemaName() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property schemaName in model DataMaskingRuleProperties"));
        }
        if (this.tableName() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property tableName in model DataMaskingRuleProperties"));
        }
        if (this.columnName() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property columnName in model DataMaskingRuleProperties"));
        }
        if (this.maskingFunction() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property maskingFunction in model DataMaskingRuleProperties"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("schemaName", this.schemaName);
        jsonWriter.writeStringField("tableName", this.tableName);
        jsonWriter.writeStringField("columnName", this.columnName);
        jsonWriter.writeStringField("maskingFunction", this.maskingFunction == null ? null : this.maskingFunction.toString());
        jsonWriter.writeStringField("ruleState", this.ruleState == null ? null : this.ruleState.toString());
        jsonWriter.writeStringField("aliasName", this.aliasName);
        jsonWriter.writeStringField("numberFrom", this.numberFrom);
        jsonWriter.writeStringField("numberTo", this.numberTo);
        jsonWriter.writeStringField("prefixSize", this.prefixSize);
        jsonWriter.writeStringField("suffixSize", this.suffixSize);
        jsonWriter.writeStringField("replacementString", this.replacementString);
        return jsonWriter.writeEndObject();
    }

    public static DataMaskingRuleProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DataMaskingRuleProperties deserializedDataMaskingRuleProperties = new DataMaskingRuleProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("schemaName".equals(fieldName)) {
                    deserializedDataMaskingRuleProperties.schemaName = reader.getString();
                    continue;
                }
                if ("tableName".equals(fieldName)) {
                    deserializedDataMaskingRuleProperties.tableName = reader.getString();
                    continue;
                }
                if ("columnName".equals(fieldName)) {
                    deserializedDataMaskingRuleProperties.columnName = reader.getString();
                    continue;
                }
                if ("maskingFunction".equals(fieldName)) {
                    deserializedDataMaskingRuleProperties.maskingFunction = DataMaskingFunction.fromString(reader.getString());
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedDataMaskingRuleProperties.id = reader.getString();
                    continue;
                }
                if ("ruleState".equals(fieldName)) {
                    deserializedDataMaskingRuleProperties.ruleState = DataMaskingRuleState.fromString(reader.getString());
                    continue;
                }
                if ("aliasName".equals(fieldName)) {
                    deserializedDataMaskingRuleProperties.aliasName = reader.getString();
                    continue;
                }
                if ("numberFrom".equals(fieldName)) {
                    deserializedDataMaskingRuleProperties.numberFrom = reader.getString();
                    continue;
                }
                if ("numberTo".equals(fieldName)) {
                    deserializedDataMaskingRuleProperties.numberTo = reader.getString();
                    continue;
                }
                if ("prefixSize".equals(fieldName)) {
                    deserializedDataMaskingRuleProperties.prefixSize = reader.getString();
                    continue;
                }
                if ("suffixSize".equals(fieldName)) {
                    deserializedDataMaskingRuleProperties.suffixSize = reader.getString();
                    continue;
                }
                if ("replacementString".equals(fieldName)) {
                    deserializedDataMaskingRuleProperties.replacementString = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataMaskingRuleProperties;
        });
    }
}

