/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ElasticPoolLicenseType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ElasticPoolPerDatabaseSettings;
import java.io.IOException;

public final class ElasticPoolUpdateProperties
implements JsonSerializable<ElasticPoolUpdateProperties> {
    private Long maxSizeBytes;
    private Double minCapacity;
    private ElasticPoolPerDatabaseSettings perDatabaseSettings;
    private Boolean zoneRedundant;
    private ElasticPoolLicenseType licenseType;
    private String maintenanceConfigurationId;
    private Integer highAvailabilityReplicaCount;

    public Long maxSizeBytes() {
        return this.maxSizeBytes;
    }

    public ElasticPoolUpdateProperties withMaxSizeBytes(Long maxSizeBytes) {
        this.maxSizeBytes = maxSizeBytes;
        return this;
    }

    public Double minCapacity() {
        return this.minCapacity;
    }

    public ElasticPoolUpdateProperties withMinCapacity(Double minCapacity) {
        this.minCapacity = minCapacity;
        return this;
    }

    public ElasticPoolPerDatabaseSettings perDatabaseSettings() {
        return this.perDatabaseSettings;
    }

    public ElasticPoolUpdateProperties withPerDatabaseSettings(ElasticPoolPerDatabaseSettings perDatabaseSettings) {
        this.perDatabaseSettings = perDatabaseSettings;
        return this;
    }

    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    public ElasticPoolUpdateProperties withZoneRedundant(Boolean zoneRedundant) {
        this.zoneRedundant = zoneRedundant;
        return this;
    }

    public ElasticPoolLicenseType licenseType() {
        return this.licenseType;
    }

    public ElasticPoolUpdateProperties withLicenseType(ElasticPoolLicenseType licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public String maintenanceConfigurationId() {
        return this.maintenanceConfigurationId;
    }

    public ElasticPoolUpdateProperties withMaintenanceConfigurationId(String maintenanceConfigurationId) {
        this.maintenanceConfigurationId = maintenanceConfigurationId;
        return this;
    }

    public Integer highAvailabilityReplicaCount() {
        return this.highAvailabilityReplicaCount;
    }

    public ElasticPoolUpdateProperties withHighAvailabilityReplicaCount(Integer highAvailabilityReplicaCount) {
        this.highAvailabilityReplicaCount = highAvailabilityReplicaCount;
        return this;
    }

    public void validate() {
        if (this.perDatabaseSettings() != null) {
            this.perDatabaseSettings().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("maxSizeBytes", this.maxSizeBytes);
        jsonWriter.writeNumberField("minCapacity", this.minCapacity);
        jsonWriter.writeJsonField("perDatabaseSettings", this.perDatabaseSettings);
        jsonWriter.writeBooleanField("zoneRedundant", this.zoneRedundant);
        jsonWriter.writeStringField("licenseType", this.licenseType == null ? null : this.licenseType.toString());
        jsonWriter.writeStringField("maintenanceConfigurationId", this.maintenanceConfigurationId);
        jsonWriter.writeNumberField("highAvailabilityReplicaCount", this.highAvailabilityReplicaCount);
        return jsonWriter.writeEndObject();
    }

    public static ElasticPoolUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ElasticPoolUpdateProperties deserializedElasticPoolUpdateProperties = new ElasticPoolUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("maxSizeBytes".equals(fieldName)) {
                    deserializedElasticPoolUpdateProperties.maxSizeBytes = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("minCapacity".equals(fieldName)) {
                    deserializedElasticPoolUpdateProperties.minCapacity = reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("perDatabaseSettings".equals(fieldName)) {
                    deserializedElasticPoolUpdateProperties.perDatabaseSettings = ElasticPoolPerDatabaseSettings.fromJson(reader);
                    continue;
                }
                if ("zoneRedundant".equals(fieldName)) {
                    deserializedElasticPoolUpdateProperties.zoneRedundant = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("licenseType".equals(fieldName)) {
                    deserializedElasticPoolUpdateProperties.licenseType = ElasticPoolLicenseType.fromString(reader.getString());
                    continue;
                }
                if ("maintenanceConfigurationId".equals(fieldName)) {
                    deserializedElasticPoolUpdateProperties.maintenanceConfigurationId = reader.getString();
                    continue;
                }
                if ("highAvailabilityReplicaCount".equals(fieldName)) {
                    deserializedElasticPoolUpdateProperties.highAvailabilityReplicaCount = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticPoolUpdateProperties;
        });
    }
}

