/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ManagedInstanceOperationParametersPair;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ManagedInstanceOperationSteps;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ManagementOperationState;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ManagedInstanceOperationProperties
implements JsonSerializable<ManagedInstanceOperationProperties> {
    private String managedInstanceName;
    private String operation;
    private String operationFriendlyName;
    private Integer percentComplete;
    private OffsetDateTime startTime;
    private ManagementOperationState state;
    private Integer errorCode;
    private String errorDescription;
    private Integer errorSeverity;
    private Boolean isUserError;
    private OffsetDateTime estimatedCompletionTime;
    private String description;
    private Boolean isCancellable;
    private ManagedInstanceOperationParametersPair operationParameters;
    private ManagedInstanceOperationSteps operationSteps;

    public String managedInstanceName() {
        return this.managedInstanceName;
    }

    public String operation() {
        return this.operation;
    }

    public String operationFriendlyName() {
        return this.operationFriendlyName;
    }

    public Integer percentComplete() {
        return this.percentComplete;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public ManagementOperationState state() {
        return this.state;
    }

    public Integer errorCode() {
        return this.errorCode;
    }

    public String errorDescription() {
        return this.errorDescription;
    }

    public Integer errorSeverity() {
        return this.errorSeverity;
    }

    public Boolean isUserError() {
        return this.isUserError;
    }

    public OffsetDateTime estimatedCompletionTime() {
        return this.estimatedCompletionTime;
    }

    public String description() {
        return this.description;
    }

    public Boolean isCancellable() {
        return this.isCancellable;
    }

    public ManagedInstanceOperationParametersPair operationParameters() {
        return this.operationParameters;
    }

    public ManagedInstanceOperationSteps operationSteps() {
        return this.operationSteps;
    }

    public void validate() {
        if (this.operationParameters() != null) {
            this.operationParameters().validate();
        }
        if (this.operationSteps() != null) {
            this.operationSteps().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ManagedInstanceOperationProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedInstanceOperationProperties deserializedManagedInstanceOperationProperties = new ManagedInstanceOperationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("managedInstanceName".equals(fieldName)) {
                    deserializedManagedInstanceOperationProperties.managedInstanceName = reader.getString();
                    continue;
                }
                if ("operation".equals(fieldName)) {
                    deserializedManagedInstanceOperationProperties.operation = reader.getString();
                    continue;
                }
                if ("operationFriendlyName".equals(fieldName)) {
                    deserializedManagedInstanceOperationProperties.operationFriendlyName = reader.getString();
                    continue;
                }
                if ("percentComplete".equals(fieldName)) {
                    deserializedManagedInstanceOperationProperties.percentComplete = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedManagedInstanceOperationProperties.startTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedManagedInstanceOperationProperties.state = ManagementOperationState.fromString(reader.getString());
                    continue;
                }
                if ("errorCode".equals(fieldName)) {
                    deserializedManagedInstanceOperationProperties.errorCode = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("errorDescription".equals(fieldName)) {
                    deserializedManagedInstanceOperationProperties.errorDescription = reader.getString();
                    continue;
                }
                if ("errorSeverity".equals(fieldName)) {
                    deserializedManagedInstanceOperationProperties.errorSeverity = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("isUserError".equals(fieldName)) {
                    deserializedManagedInstanceOperationProperties.isUserError = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("estimatedCompletionTime".equals(fieldName)) {
                    deserializedManagedInstanceOperationProperties.estimatedCompletionTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedManagedInstanceOperationProperties.description = reader.getString();
                    continue;
                }
                if ("isCancellable".equals(fieldName)) {
                    deserializedManagedInstanceOperationProperties.isCancellable = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("operationParameters".equals(fieldName)) {
                    deserializedManagedInstanceOperationProperties.operationParameters = ManagedInstanceOperationParametersPair.fromJson(reader);
                    continue;
                }
                if ("operationSteps".equals(fieldName)) {
                    deserializedManagedInstanceOperationProperties.operationSteps = ManagedInstanceOperationSteps.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedInstanceOperationProperties;
        });
    }
}

