/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.RecommendedActionErrorInfo;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.RecommendedActionImpactRecord;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.RecommendedActionImplementationInfo;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.RecommendedActionInitiatedBy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.RecommendedActionMetricInfo;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.RecommendedActionStateInfo;
import java.io.IOException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class RecommendedActionProperties
implements JsonSerializable<RecommendedActionProperties> {
    private String recommendationReason;
    private OffsetDateTime validSince;
    private OffsetDateTime lastRefresh;
    private RecommendedActionStateInfo state;
    private Boolean isExecutableAction;
    private Boolean isRevertableAction;
    private Boolean isArchivedAction;
    private OffsetDateTime executeActionStartTime;
    private Duration executeActionDuration;
    private OffsetDateTime revertActionStartTime;
    private Duration revertActionDuration;
    private RecommendedActionInitiatedBy executeActionInitiatedBy;
    private OffsetDateTime executeActionInitiatedTime;
    private RecommendedActionInitiatedBy revertActionInitiatedBy;
    private OffsetDateTime revertActionInitiatedTime;
    private Integer score;
    private RecommendedActionImplementationInfo implementationDetails;
    private RecommendedActionErrorInfo errorDetails;
    private List<RecommendedActionImpactRecord> estimatedImpact;
    private List<RecommendedActionImpactRecord> observedImpact;
    private List<RecommendedActionMetricInfo> timeSeries;
    private List<String> linkedObjects;
    private Map<String, Object> details;
    private static final ClientLogger LOGGER = new ClientLogger(RecommendedActionProperties.class);

    public String recommendationReason() {
        return this.recommendationReason;
    }

    public OffsetDateTime validSince() {
        return this.validSince;
    }

    public OffsetDateTime lastRefresh() {
        return this.lastRefresh;
    }

    public RecommendedActionStateInfo state() {
        return this.state;
    }

    public RecommendedActionProperties withState(RecommendedActionStateInfo state) {
        this.state = state;
        return this;
    }

    public Boolean isExecutableAction() {
        return this.isExecutableAction;
    }

    public Boolean isRevertableAction() {
        return this.isRevertableAction;
    }

    public Boolean isArchivedAction() {
        return this.isArchivedAction;
    }

    public OffsetDateTime executeActionStartTime() {
        return this.executeActionStartTime;
    }

    public Duration executeActionDuration() {
        return this.executeActionDuration;
    }

    public OffsetDateTime revertActionStartTime() {
        return this.revertActionStartTime;
    }

    public Duration revertActionDuration() {
        return this.revertActionDuration;
    }

    public RecommendedActionInitiatedBy executeActionInitiatedBy() {
        return this.executeActionInitiatedBy;
    }

    public OffsetDateTime executeActionInitiatedTime() {
        return this.executeActionInitiatedTime;
    }

    public RecommendedActionInitiatedBy revertActionInitiatedBy() {
        return this.revertActionInitiatedBy;
    }

    public OffsetDateTime revertActionInitiatedTime() {
        return this.revertActionInitiatedTime;
    }

    public Integer score() {
        return this.score;
    }

    public RecommendedActionImplementationInfo implementationDetails() {
        return this.implementationDetails;
    }

    public RecommendedActionErrorInfo errorDetails() {
        return this.errorDetails;
    }

    public List<RecommendedActionImpactRecord> estimatedImpact() {
        return this.estimatedImpact;
    }

    public List<RecommendedActionImpactRecord> observedImpact() {
        return this.observedImpact;
    }

    public List<RecommendedActionMetricInfo> timeSeries() {
        return this.timeSeries;
    }

    public List<String> linkedObjects() {
        return this.linkedObjects;
    }

    public Map<String, Object> details() {
        return this.details;
    }

    public void validate() {
        if (this.state() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property state in model RecommendedActionProperties"));
        }
        this.state().validate();
        if (this.implementationDetails() != null) {
            this.implementationDetails().validate();
        }
        if (this.errorDetails() != null) {
            this.errorDetails().validate();
        }
        if (this.estimatedImpact() != null) {
            this.estimatedImpact().forEach(e -> e.validate());
        }
        if (this.observedImpact() != null) {
            this.observedImpact().forEach(e -> e.validate());
        }
        if (this.timeSeries() != null) {
            this.timeSeries().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("state", this.state);
        return jsonWriter.writeEndObject();
    }

    public static RecommendedActionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RecommendedActionProperties deserializedRecommendedActionProperties = new RecommendedActionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedRecommendedActionProperties.state = RecommendedActionStateInfo.fromJson(reader);
                    continue;
                }
                if ("recommendationReason".equals(fieldName)) {
                    deserializedRecommendedActionProperties.recommendationReason = reader.getString();
                    continue;
                }
                if ("validSince".equals(fieldName)) {
                    deserializedRecommendedActionProperties.validSince = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("lastRefresh".equals(fieldName)) {
                    deserializedRecommendedActionProperties.lastRefresh = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("isExecutableAction".equals(fieldName)) {
                    deserializedRecommendedActionProperties.isExecutableAction = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isRevertableAction".equals(fieldName)) {
                    deserializedRecommendedActionProperties.isRevertableAction = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isArchivedAction".equals(fieldName)) {
                    deserializedRecommendedActionProperties.isArchivedAction = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("executeActionStartTime".equals(fieldName)) {
                    deserializedRecommendedActionProperties.executeActionStartTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("executeActionDuration".equals(fieldName)) {
                    deserializedRecommendedActionProperties.executeActionDuration = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("revertActionStartTime".equals(fieldName)) {
                    deserializedRecommendedActionProperties.revertActionStartTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("revertActionDuration".equals(fieldName)) {
                    deserializedRecommendedActionProperties.revertActionDuration = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("executeActionInitiatedBy".equals(fieldName)) {
                    deserializedRecommendedActionProperties.executeActionInitiatedBy = RecommendedActionInitiatedBy.fromString(reader.getString());
                    continue;
                }
                if ("executeActionInitiatedTime".equals(fieldName)) {
                    deserializedRecommendedActionProperties.executeActionInitiatedTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("revertActionInitiatedBy".equals(fieldName)) {
                    deserializedRecommendedActionProperties.revertActionInitiatedBy = RecommendedActionInitiatedBy.fromString(reader.getString());
                    continue;
                }
                if ("revertActionInitiatedTime".equals(fieldName)) {
                    deserializedRecommendedActionProperties.revertActionInitiatedTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("score".equals(fieldName)) {
                    deserializedRecommendedActionProperties.score = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("implementationDetails".equals(fieldName)) {
                    deserializedRecommendedActionProperties.implementationDetails = RecommendedActionImplementationInfo.fromJson(reader);
                    continue;
                }
                if ("errorDetails".equals(fieldName)) {
                    deserializedRecommendedActionProperties.errorDetails = RecommendedActionErrorInfo.fromJson(reader);
                    continue;
                }
                if ("estimatedImpact".equals(fieldName)) {
                    List<RecommendedActionImpactRecord> estimatedImpact = reader.readArray(reader1 -> RecommendedActionImpactRecord.fromJson(reader1));
                    deserializedRecommendedActionProperties.estimatedImpact = estimatedImpact;
                    continue;
                }
                if ("observedImpact".equals(fieldName)) {
                    List<RecommendedActionImpactRecord> observedImpact = reader.readArray(reader1 -> RecommendedActionImpactRecord.fromJson(reader1));
                    deserializedRecommendedActionProperties.observedImpact = observedImpact;
                    continue;
                }
                if ("timeSeries".equals(fieldName)) {
                    List<RecommendedActionMetricInfo> timeSeries = reader.readArray(reader1 -> RecommendedActionMetricInfo.fromJson(reader1));
                    deserializedRecommendedActionProperties.timeSeries = timeSeries;
                    continue;
                }
                if ("linkedObjects".equals(fieldName)) {
                    List<String> linkedObjects = reader.readArray(reader1 -> reader1.getString());
                    deserializedRecommendedActionProperties.linkedObjects = linkedObjects;
                    continue;
                }
                if ("details".equals(fieldName)) {
                    Map<String, Object> details = reader.readMap(reader1 -> reader1.readUntyped());
                    deserializedRecommendedActionProperties.details = details;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRecommendedActionProperties;
        });
    }
}

