/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.BodyParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Put;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.DataMaskingRulesClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.DataMaskingRuleInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.DataMaskingPolicyName;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.DataMaskingRuleListResult;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class DataMaskingRulesClientImpl
implements DataMaskingRulesClient {
    private final DataMaskingRulesService service;
    private final SqlManagementClientImpl client;

    DataMaskingRulesClientImpl(SqlManagementClientImpl client) {
        this.service = RestProxy.create(DataMaskingRulesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DataMaskingRuleInner>> listByDatabaseSinglePageAsync(String resourceGroupName, String serverName, String databaseName, DataMaskingPolicyName dataMaskingPolicyName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (dataMaskingPolicyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter dataMaskingPolicyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByDatabase(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, dataMaskingPolicyName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, DataMaskingRuleInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataMaskingRuleListResult)res.getValue()).value(), ((DataMaskingRuleListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DataMaskingRuleInner>> listByDatabaseSinglePageAsync(String resourceGroupName, String serverName, String databaseName, DataMaskingPolicyName dataMaskingPolicyName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (dataMaskingPolicyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter dataMaskingPolicyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByDatabase(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, dataMaskingPolicyName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase<Object, DataMaskingRuleInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataMaskingRuleListResult)res.getValue()).value(), ((DataMaskingRuleListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DataMaskingRuleInner> listByDatabaseAsync(String resourceGroupName, String serverName, String databaseName, DataMaskingPolicyName dataMaskingPolicyName) {
        return new PagedFlux<DataMaskingRuleInner>(() -> this.listByDatabaseSinglePageAsync(resourceGroupName, serverName, databaseName, dataMaskingPolicyName), nextLink -> this.listByDatabaseNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DataMaskingRuleInner> listByDatabaseAsync(String resourceGroupName, String serverName, String databaseName, DataMaskingPolicyName dataMaskingPolicyName, Context context) {
        return new PagedFlux<DataMaskingRuleInner>(() -> this.listByDatabaseSinglePageAsync(resourceGroupName, serverName, databaseName, dataMaskingPolicyName, context), nextLink -> this.listByDatabaseNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataMaskingRuleInner> listByDatabase(String resourceGroupName, String serverName, String databaseName, DataMaskingPolicyName dataMaskingPolicyName) {
        return new PagedIterable<DataMaskingRuleInner>(this.listByDatabaseAsync(resourceGroupName, serverName, databaseName, dataMaskingPolicyName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataMaskingRuleInner> listByDatabase(String resourceGroupName, String serverName, String databaseName, DataMaskingPolicyName dataMaskingPolicyName, Context context) {
        return new PagedIterable<DataMaskingRuleInner>(this.listByDatabaseAsync(resourceGroupName, serverName, databaseName, dataMaskingPolicyName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataMaskingRuleInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, String databaseName, DataMaskingPolicyName dataMaskingPolicyName, String dataMaskingRuleName, DataMaskingRuleInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (dataMaskingPolicyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter dataMaskingPolicyName is required and cannot be null."));
        }
        if (dataMaskingRuleName == null) {
            return Mono.error(new IllegalArgumentException("Parameter dataMaskingRuleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, dataMaskingPolicyName, dataMaskingRuleName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DataMaskingRuleInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, String databaseName, DataMaskingPolicyName dataMaskingPolicyName, String dataMaskingRuleName, DataMaskingRuleInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (dataMaskingPolicyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter dataMaskingPolicyName is required and cannot be null."));
        }
        if (dataMaskingRuleName == null) {
            return Mono.error(new IllegalArgumentException("Parameter dataMaskingRuleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, dataMaskingPolicyName, dataMaskingRuleName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataMaskingRuleInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, DataMaskingPolicyName dataMaskingPolicyName, String dataMaskingRuleName, DataMaskingRuleInner parameters) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, databaseName, dataMaskingPolicyName, dataMaskingRuleName, parameters).flatMap(res -> Mono.justOrEmpty((DataMaskingRuleInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataMaskingRuleInner> createOrUpdateWithResponse(String resourceGroupName, String serverName, String databaseName, DataMaskingPolicyName dataMaskingPolicyName, String dataMaskingRuleName, DataMaskingRuleInner parameters, Context context) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, databaseName, dataMaskingPolicyName, dataMaskingRuleName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataMaskingRuleInner createOrUpdate(String resourceGroupName, String serverName, String databaseName, DataMaskingPolicyName dataMaskingPolicyName, String dataMaskingRuleName, DataMaskingRuleInner parameters) {
        return this.createOrUpdateWithResponse(resourceGroupName, serverName, databaseName, dataMaskingPolicyName, dataMaskingRuleName, parameters, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DataMaskingRuleInner>> listByDatabaseNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByDatabaseNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, DataMaskingRuleInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataMaskingRuleListResult)res.getValue()).value(), ((DataMaskingRuleListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DataMaskingRuleInner>> listByDatabaseNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByDatabaseNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, DataMaskingRuleInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataMaskingRuleListResult)res.getValue()).value(), ((DataMaskingRuleListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientD")
    public static interface DataMaskingRulesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/dataMaskingPolicies/{dataMaskingPolicyName}/rules")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DataMaskingRuleListResult>> listByDatabase(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="dataMaskingPolicyName") DataMaskingPolicyName var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/dataMaskingPolicies/{dataMaskingPolicyName}/rules/{dataMaskingRuleName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DataMaskingRuleInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="dataMaskingPolicyName") DataMaskingPolicyName var5, @PathParam(value="dataMaskingRuleName") String var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, @BodyParam(value="application/json") DataMaskingRuleInner var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DataMaskingRuleListResult>> listByDatabaseNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

