/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Post;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.management.polling.PollResult;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollerFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.SyncPoller;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.ManagedDatabaseVulnerabilityAssessmentScansClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.DatabaseVulnerabilityAssessmentScansExportInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.VulnerabilityAssessmentScanRecordInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.VulnerabilityAssessmentName;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.VulnerabilityAssessmentScanRecordListResult;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;

public final class ManagedDatabaseVulnerabilityAssessmentScansClientImpl
implements ManagedDatabaseVulnerabilityAssessmentScansClient {
    private final ManagedDatabaseVulnerabilityAssessmentScansService service;
    private final SqlManagementClientImpl client;

    ManagedDatabaseVulnerabilityAssessmentScansClientImpl(SqlManagementClientImpl client) {
        this.service = RestProxy.create(ManagedDatabaseVulnerabilityAssessmentScansService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VulnerabilityAssessmentScanRecordInner>> listByDatabaseSinglePageAsync(String resourceGroupName, String managedInstanceName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByDatabase(this.client.getEndpoint(), resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, VulnerabilityAssessmentScanRecordInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VulnerabilityAssessmentScanRecordListResult)res.getValue()).value(), ((VulnerabilityAssessmentScanRecordListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VulnerabilityAssessmentScanRecordInner>> listByDatabaseSinglePageAsync(String resourceGroupName, String managedInstanceName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByDatabase(this.client.getEndpoint(), resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase<Object, VulnerabilityAssessmentScanRecordInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VulnerabilityAssessmentScanRecordListResult)res.getValue()).value(), ((VulnerabilityAssessmentScanRecordListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<VulnerabilityAssessmentScanRecordInner> listByDatabaseAsync(String resourceGroupName, String managedInstanceName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName) {
        return new PagedFlux<VulnerabilityAssessmentScanRecordInner>(() -> this.listByDatabaseSinglePageAsync(resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName), nextLink -> this.listByDatabaseNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<VulnerabilityAssessmentScanRecordInner> listByDatabaseAsync(String resourceGroupName, String managedInstanceName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, Context context) {
        return new PagedFlux<VulnerabilityAssessmentScanRecordInner>(() -> this.listByDatabaseSinglePageAsync(resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, context), nextLink -> this.listByDatabaseNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VulnerabilityAssessmentScanRecordInner> listByDatabase(String resourceGroupName, String managedInstanceName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName) {
        return new PagedIterable<VulnerabilityAssessmentScanRecordInner>(this.listByDatabaseAsync(resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VulnerabilityAssessmentScanRecordInner> listByDatabase(String resourceGroupName, String managedInstanceName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, Context context) {
        return new PagedIterable<VulnerabilityAssessmentScanRecordInner>(this.listByDatabaseAsync(resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<VulnerabilityAssessmentScanRecordInner>> getWithResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (scanId == null) {
            return Mono.error(new IllegalArgumentException("Parameter scanId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, scanId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<VulnerabilityAssessmentScanRecordInner>> getWithResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (scanId == null) {
            return Mono.error(new IllegalArgumentException("Parameter scanId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, scanId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VulnerabilityAssessmentScanRecordInner> getAsync(String resourceGroupName, String managedInstanceName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        return this.getWithResponseAsync(resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, scanId).flatMap(res -> Mono.justOrEmpty((VulnerabilityAssessmentScanRecordInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<VulnerabilityAssessmentScanRecordInner> getWithResponse(String resourceGroupName, String managedInstanceName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, Context context) {
        return this.getWithResponseAsync(resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, scanId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VulnerabilityAssessmentScanRecordInner get(String resourceGroupName, String managedInstanceName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        return this.getWithResponse(resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, scanId, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DatabaseVulnerabilityAssessmentScansExportInner>> exportWithResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (scanId == null) {
            return Mono.error(new IllegalArgumentException("Parameter scanId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.export(this.client.getEndpoint(), resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, scanId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DatabaseVulnerabilityAssessmentScansExportInner>> exportWithResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (scanId == null) {
            return Mono.error(new IllegalArgumentException("Parameter scanId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.export(this.client.getEndpoint(), resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, scanId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DatabaseVulnerabilityAssessmentScansExportInner> exportAsync(String resourceGroupName, String managedInstanceName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        return this.exportWithResponseAsync(resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, scanId).flatMap(res -> Mono.justOrEmpty((DatabaseVulnerabilityAssessmentScansExportInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DatabaseVulnerabilityAssessmentScansExportInner> exportWithResponse(String resourceGroupName, String managedInstanceName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, Context context) {
        return this.exportWithResponseAsync(resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, scanId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatabaseVulnerabilityAssessmentScansExportInner export(String resourceGroupName, String managedInstanceName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        return this.exportWithResponse(resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, scanId, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> initiateScanWithResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (scanId == null) {
            return Mono.error(new IllegalArgumentException("Parameter scanId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.initiateScan(this.client.getEndpoint(), resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, scanId, this.client.getSubscriptionId(), this.client.getApiVersion(), (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> initiateScanWithResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (scanId == null) {
            return Mono.error(new IllegalArgumentException("Parameter scanId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.initiateScan(this.client.getEndpoint(), resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, scanId, this.client.getSubscriptionId(), this.client.getApiVersion(), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginInitiateScanAsync(String resourceGroupName, String managedInstanceName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.initiateScanWithResponseAsync(resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, scanId);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginInitiateScanAsync(String resourceGroupName, String managedInstanceName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.initiateScanWithResponseAsync(resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, scanId, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginInitiateScan(String resourceGroupName, String managedInstanceName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        return this.beginInitiateScanAsync(resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, scanId).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginInitiateScan(String resourceGroupName, String managedInstanceName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, Context context) {
        return this.beginInitiateScanAsync(resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, scanId, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> initiateScanAsync(String resourceGroupName, String managedInstanceName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        return this.beginInitiateScanAsync(resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, scanId).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> initiateScanAsync(String resourceGroupName, String managedInstanceName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, Context context) {
        return this.beginInitiateScanAsync(resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, scanId, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void initiateScan(String resourceGroupName, String managedInstanceName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        this.initiateScanAsync(resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, scanId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void initiateScan(String resourceGroupName, String managedInstanceName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, Context context) {
        this.initiateScanAsync(resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, scanId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VulnerabilityAssessmentScanRecordInner>> listByDatabaseNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByDatabaseNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, VulnerabilityAssessmentScanRecordInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VulnerabilityAssessmentScanRecordListResult)res.getValue()).value(), ((VulnerabilityAssessmentScanRecordListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VulnerabilityAssessmentScanRecordInner>> listByDatabaseNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByDatabaseNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, VulnerabilityAssessmentScanRecordInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VulnerabilityAssessmentScanRecordListResult)res.getValue()).value(), ((VulnerabilityAssessmentScanRecordListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientM")
    public static interface ManagedDatabaseVulnerabilityAssessmentScansService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VulnerabilityAssessmentScanRecordListResult>> listByDatabase(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="managedInstanceName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="vulnerabilityAssessmentName") VulnerabilityAssessmentName var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VulnerabilityAssessmentScanRecordInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="managedInstanceName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="vulnerabilityAssessmentName") VulnerabilityAssessmentName var5, @PathParam(value="scanId") String var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/export")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DatabaseVulnerabilityAssessmentScansExportInner>> export(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="managedInstanceName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="vulnerabilityAssessmentName") VulnerabilityAssessmentName var5, @PathParam(value="scanId") String var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/initiateScan")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> initiateScan(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="managedInstanceName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="vulnerabilityAssessmentName") VulnerabilityAssessmentName var5, @PathParam(value="scanId") String var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VulnerabilityAssessmentScanRecordListResult>> listByDatabaseNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

