/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.BodyParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Delete;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Post;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Put;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.management.polling.PollResult;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollerFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.SyncPoller;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.ManagedServerDnsAliasesClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.ManagedServerDnsAliasInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ManagedServerDnsAliasAcquisition;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ManagedServerDnsAliasCreation;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ManagedServerDnsAliasListResult;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;

public final class ManagedServerDnsAliasesClientImpl
implements ManagedServerDnsAliasesClient {
    private final ManagedServerDnsAliasesService service;
    private final SqlManagementClientImpl client;

    ManagedServerDnsAliasesClientImpl(SqlManagementClientImpl client) {
        this.service = RestProxy.create(ManagedServerDnsAliasesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedServerDnsAliasInner>> listByManagedInstanceSinglePageAsync(String resourceGroupName, String managedInstanceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByManagedInstance(this.client.getEndpoint(), resourceGroupName, managedInstanceName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, ManagedServerDnsAliasInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedServerDnsAliasListResult)res.getValue()).value(), ((ManagedServerDnsAliasListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedServerDnsAliasInner>> listByManagedInstanceSinglePageAsync(String resourceGroupName, String managedInstanceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByManagedInstance(this.client.getEndpoint(), resourceGroupName, managedInstanceName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase<Object, ManagedServerDnsAliasInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedServerDnsAliasListResult)res.getValue()).value(), ((ManagedServerDnsAliasListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ManagedServerDnsAliasInner> listByManagedInstanceAsync(String resourceGroupName, String managedInstanceName) {
        return new PagedFlux<ManagedServerDnsAliasInner>(() -> this.listByManagedInstanceSinglePageAsync(resourceGroupName, managedInstanceName), nextLink -> this.listByManagedInstanceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ManagedServerDnsAliasInner> listByManagedInstanceAsync(String resourceGroupName, String managedInstanceName, Context context) {
        return new PagedFlux<ManagedServerDnsAliasInner>(() -> this.listByManagedInstanceSinglePageAsync(resourceGroupName, managedInstanceName, context), nextLink -> this.listByManagedInstanceNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ManagedServerDnsAliasInner> listByManagedInstance(String resourceGroupName, String managedInstanceName) {
        return new PagedIterable<ManagedServerDnsAliasInner>(this.listByManagedInstanceAsync(resourceGroupName, managedInstanceName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ManagedServerDnsAliasInner> listByManagedInstance(String resourceGroupName, String managedInstanceName, Context context) {
        return new PagedIterable<ManagedServerDnsAliasInner>(this.listByManagedInstanceAsync(resourceGroupName, managedInstanceName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ManagedServerDnsAliasInner>> getWithResponseAsync(String resourceGroupName, String managedInstanceName, String dnsAliasName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (dnsAliasName == null) {
            return Mono.error(new IllegalArgumentException("Parameter dnsAliasName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, managedInstanceName, dnsAliasName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ManagedServerDnsAliasInner>> getWithResponseAsync(String resourceGroupName, String managedInstanceName, String dnsAliasName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (dnsAliasName == null) {
            return Mono.error(new IllegalArgumentException("Parameter dnsAliasName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, managedInstanceName, dnsAliasName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ManagedServerDnsAliasInner> getAsync(String resourceGroupName, String managedInstanceName, String dnsAliasName) {
        return this.getWithResponseAsync(resourceGroupName, managedInstanceName, dnsAliasName).flatMap(res -> Mono.justOrEmpty((ManagedServerDnsAliasInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ManagedServerDnsAliasInner> getWithResponse(String resourceGroupName, String managedInstanceName, String dnsAliasName, Context context) {
        return this.getWithResponseAsync(resourceGroupName, managedInstanceName, dnsAliasName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedServerDnsAliasInner get(String resourceGroupName, String managedInstanceName, String dnsAliasName) {
        return this.getWithResponse(resourceGroupName, managedInstanceName, dnsAliasName, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String managedInstanceName, String dnsAliasName, ManagedServerDnsAliasCreation parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (dnsAliasName == null) {
            return Mono.error(new IllegalArgumentException("Parameter dnsAliasName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, managedInstanceName, dnsAliasName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String managedInstanceName, String dnsAliasName, ManagedServerDnsAliasCreation parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (dnsAliasName == null) {
            return Mono.error(new IllegalArgumentException("Parameter dnsAliasName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, managedInstanceName, dnsAliasName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ManagedServerDnsAliasInner>, ManagedServerDnsAliasInner> beginCreateOrUpdateAsync(String resourceGroupName, String managedInstanceName, String dnsAliasName, ManagedServerDnsAliasCreation parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, managedInstanceName, dnsAliasName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ManagedServerDnsAliasInner.class), (Type)((Object)ManagedServerDnsAliasInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ManagedServerDnsAliasInner>, ManagedServerDnsAliasInner> beginCreateOrUpdateAsync(String resourceGroupName, String managedInstanceName, String dnsAliasName, ManagedServerDnsAliasCreation parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, managedInstanceName, dnsAliasName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ManagedServerDnsAliasInner.class), (Type)((Object)ManagedServerDnsAliasInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ManagedServerDnsAliasInner>, ManagedServerDnsAliasInner> beginCreateOrUpdate(String resourceGroupName, String managedInstanceName, String dnsAliasName, ManagedServerDnsAliasCreation parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, managedInstanceName, dnsAliasName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ManagedServerDnsAliasInner>, ManagedServerDnsAliasInner> beginCreateOrUpdate(String resourceGroupName, String managedInstanceName, String dnsAliasName, ManagedServerDnsAliasCreation parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, managedInstanceName, dnsAliasName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ManagedServerDnsAliasInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, String dnsAliasName, ManagedServerDnsAliasCreation parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, managedInstanceName, dnsAliasName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ManagedServerDnsAliasInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, String dnsAliasName, ManagedServerDnsAliasCreation parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, managedInstanceName, dnsAliasName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedServerDnsAliasInner createOrUpdate(String resourceGroupName, String managedInstanceName, String dnsAliasName, ManagedServerDnsAliasCreation parameters) {
        return this.createOrUpdateAsync(resourceGroupName, managedInstanceName, dnsAliasName, parameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedServerDnsAliasInner createOrUpdate(String resourceGroupName, String managedInstanceName, String dnsAliasName, ManagedServerDnsAliasCreation parameters, Context context) {
        return this.createOrUpdateAsync(resourceGroupName, managedInstanceName, dnsAliasName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String managedInstanceName, String dnsAliasName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (dnsAliasName == null) {
            return Mono.error(new IllegalArgumentException("Parameter dnsAliasName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, managedInstanceName, dnsAliasName, this.client.getSubscriptionId(), this.client.getApiVersion(), (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String managedInstanceName, String dnsAliasName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (dnsAliasName == null) {
            return Mono.error(new IllegalArgumentException("Parameter dnsAliasName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, managedInstanceName, dnsAliasName, this.client.getSubscriptionId(), this.client.getApiVersion(), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String managedInstanceName, String dnsAliasName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, managedInstanceName, dnsAliasName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String managedInstanceName, String dnsAliasName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, managedInstanceName, dnsAliasName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String managedInstanceName, String dnsAliasName) {
        return this.beginDeleteAsync(resourceGroupName, managedInstanceName, dnsAliasName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String managedInstanceName, String dnsAliasName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, managedInstanceName, dnsAliasName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String managedInstanceName, String dnsAliasName) {
        return this.beginDeleteAsync(resourceGroupName, managedInstanceName, dnsAliasName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String managedInstanceName, String dnsAliasName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, managedInstanceName, dnsAliasName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String managedInstanceName, String dnsAliasName) {
        this.deleteAsync(resourceGroupName, managedInstanceName, dnsAliasName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String managedInstanceName, String dnsAliasName, Context context) {
        this.deleteAsync(resourceGroupName, managedInstanceName, dnsAliasName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> acquireWithResponseAsync(String resourceGroupName, String managedInstanceName, String dnsAliasName, ManagedServerDnsAliasAcquisition parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (dnsAliasName == null) {
            return Mono.error(new IllegalArgumentException("Parameter dnsAliasName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.acquire(this.client.getEndpoint(), resourceGroupName, managedInstanceName, dnsAliasName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> acquireWithResponseAsync(String resourceGroupName, String managedInstanceName, String dnsAliasName, ManagedServerDnsAliasAcquisition parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (dnsAliasName == null) {
            return Mono.error(new IllegalArgumentException("Parameter dnsAliasName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.acquire(this.client.getEndpoint(), resourceGroupName, managedInstanceName, dnsAliasName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ManagedServerDnsAliasInner>, ManagedServerDnsAliasInner> beginAcquireAsync(String resourceGroupName, String managedInstanceName, String dnsAliasName, ManagedServerDnsAliasAcquisition parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.acquireWithResponseAsync(resourceGroupName, managedInstanceName, dnsAliasName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ManagedServerDnsAliasInner.class), (Type)((Object)ManagedServerDnsAliasInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ManagedServerDnsAliasInner>, ManagedServerDnsAliasInner> beginAcquireAsync(String resourceGroupName, String managedInstanceName, String dnsAliasName, ManagedServerDnsAliasAcquisition parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.acquireWithResponseAsync(resourceGroupName, managedInstanceName, dnsAliasName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ManagedServerDnsAliasInner.class), (Type)((Object)ManagedServerDnsAliasInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ManagedServerDnsAliasInner>, ManagedServerDnsAliasInner> beginAcquire(String resourceGroupName, String managedInstanceName, String dnsAliasName, ManagedServerDnsAliasAcquisition parameters) {
        return this.beginAcquireAsync(resourceGroupName, managedInstanceName, dnsAliasName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ManagedServerDnsAliasInner>, ManagedServerDnsAliasInner> beginAcquire(String resourceGroupName, String managedInstanceName, String dnsAliasName, ManagedServerDnsAliasAcquisition parameters, Context context) {
        return this.beginAcquireAsync(resourceGroupName, managedInstanceName, dnsAliasName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ManagedServerDnsAliasInner> acquireAsync(String resourceGroupName, String managedInstanceName, String dnsAliasName, ManagedServerDnsAliasAcquisition parameters) {
        return this.beginAcquireAsync(resourceGroupName, managedInstanceName, dnsAliasName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ManagedServerDnsAliasInner> acquireAsync(String resourceGroupName, String managedInstanceName, String dnsAliasName, ManagedServerDnsAliasAcquisition parameters, Context context) {
        return this.beginAcquireAsync(resourceGroupName, managedInstanceName, dnsAliasName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedServerDnsAliasInner acquire(String resourceGroupName, String managedInstanceName, String dnsAliasName, ManagedServerDnsAliasAcquisition parameters) {
        return this.acquireAsync(resourceGroupName, managedInstanceName, dnsAliasName, parameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedServerDnsAliasInner acquire(String resourceGroupName, String managedInstanceName, String dnsAliasName, ManagedServerDnsAliasAcquisition parameters, Context context) {
        return this.acquireAsync(resourceGroupName, managedInstanceName, dnsAliasName, parameters, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedServerDnsAliasInner>> listByManagedInstanceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByManagedInstanceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, ManagedServerDnsAliasInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedServerDnsAliasListResult)res.getValue()).value(), ((ManagedServerDnsAliasListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedServerDnsAliasInner>> listByManagedInstanceNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByManagedInstanceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, ManagedServerDnsAliasInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedServerDnsAliasListResult)res.getValue()).value(), ((ManagedServerDnsAliasListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientM")
    public static interface ManagedServerDnsAliasesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/dnsAliases")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedServerDnsAliasListResult>> listByManagedInstance(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="managedInstanceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/dnsAliases/{dnsAliasName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedServerDnsAliasInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="managedInstanceName") String var3, @PathParam(value="dnsAliasName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/dnsAliases/{dnsAliasName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="managedInstanceName") String var3, @PathParam(value="dnsAliasName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") ManagedServerDnsAliasCreation var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/dnsAliases/{dnsAliasName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="managedInstanceName") String var3, @PathParam(value="dnsAliasName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/dnsAliases/{dnsAliasName}/acquire")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> acquire(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="managedInstanceName") String var3, @PathParam(value="dnsAliasName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") ManagedServerDnsAliasAcquisition var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedServerDnsAliasListResult>> listByManagedInstanceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

