/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Region;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.implementation.RefreshableWrapperImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.SqlServerManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.RestorableDroppedDatabaseInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlRestorableDroppedDatabase;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.time.OffsetDateTime;

public class SqlRestorableDroppedDatabaseImpl
extends RefreshableWrapperImpl<RestorableDroppedDatabaseInner, SqlRestorableDroppedDatabase>
implements SqlRestorableDroppedDatabase {
    private final String sqlServerName;
    private final String resourceGroupName;
    private final SqlServerManager sqlServerManager;

    protected SqlRestorableDroppedDatabaseImpl(String resourceGroupName, String sqlServerName, RestorableDroppedDatabaseInner innerObject, SqlServerManager sqlServerManager) {
        super(innerObject);
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.sqlServerManager = sqlServerManager;
    }

    @Override
    public Region region() {
        return Region.fromName(((RestorableDroppedDatabaseInner)this.innerModel()).location());
    }

    @Override
    public String databaseName() {
        return ((RestorableDroppedDatabaseInner)this.innerModel()).databaseName();
    }

    @Override
    public String edition() {
        return ((RestorableDroppedDatabaseInner)this.innerModel()).sku().tier();
    }

    @Override
    public String maxSizeBytes() {
        return ((RestorableDroppedDatabaseInner)this.innerModel()).maxSizeBytes() == null ? null : ((RestorableDroppedDatabaseInner)this.innerModel()).maxSizeBytes().toString();
    }

    @Override
    public OffsetDateTime creationDate() {
        return ((RestorableDroppedDatabaseInner)this.innerModel()).creationDate();
    }

    @Override
    public OffsetDateTime deletionDate() {
        return ((RestorableDroppedDatabaseInner)this.innerModel()).deletionDate();
    }

    @Override
    public OffsetDateTime earliestRestoreDate() {
        return ((RestorableDroppedDatabaseInner)this.innerModel()).earliestRestoreDate();
    }

    @Override
    protected Mono<RestorableDroppedDatabaseInner> getInnerAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getRestorableDroppedDatabases().getAsync(this.resourceGroupName, this.sqlServerName, ((RestorableDroppedDatabaseInner)this.innerModel()).id());
    }

    @Override
    public String name() {
        return ((RestorableDroppedDatabaseInner)this.innerModel()).name();
    }

    @Override
    public String id() {
        return ((RestorableDroppedDatabaseInner)this.innerModel()).id();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }
}

