/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.SqlServerManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.SyncFullSchemaPropertiesInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.SyncMemberInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlSyncFullSchemaPropertyImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlSyncGroupImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlDatabase;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlSyncFullSchemaProperty;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlSyncGroup;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlSyncMember;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlSyncMemberOperations;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SyncDirection;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SyncMemberDbType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SyncMemberState;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Objects;

public class SqlSyncMemberImpl
extends ExternalChildResourceImpl<SqlSyncMember, SyncMemberInner, SqlSyncGroupImpl, SqlSyncGroup>
implements SqlSyncMember,
SqlSyncMember.Update,
SqlSyncMemberOperations.SqlSyncMemberOperationsDefinition {
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;
    private String sqlDatabaseName;
    private String sqlSyncGroupName;

    SqlSyncMemberImpl(String name, SqlSyncGroupImpl parent, SyncMemberInner innerObject, SqlServerManager sqlServerManager) {
        super(name, parent, innerObject);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName();
        this.sqlServerName = parent.sqlServerName();
        this.sqlDatabaseName = parent.sqlDatabaseName();
        this.sqlSyncGroupName = parent.name();
    }

    SqlSyncMemberImpl(String resourceGroupName, String sqlServerName, String sqlDatabaseName, String sqlSyncGroupName, String name, SyncMemberInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.sqlDatabaseName = sqlDatabaseName;
        this.sqlSyncGroupName = sqlSyncGroupName;
    }

    SqlSyncMemberImpl(String name, SyncMemberInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        if (innerObject != null && innerObject.id() != null) {
            try {
                ResourceId resourceId = ResourceId.fromString(innerObject.id());
                this.resourceGroupName = resourceId.resourceGroupName();
                this.sqlServerName = resourceId.parent().parent().parent().name();
                this.sqlDatabaseName = resourceId.parent().parent().name();
                this.sqlSyncGroupName = resourceId.parent().name();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public String id() {
        return ((SyncMemberInner)this.innerModel()).id();
    }

    @Override
    public String sqlServerName() {
        return this.sqlServerName;
    }

    @Override
    public String sqlDatabaseName() {
        return this.sqlDatabaseName;
    }

    @Override
    public String sqlSyncGroupName() {
        return this.sqlSyncGroupName;
    }

    @Override
    public String parentId() {
        return ResourceUtils.parentResourceIdFromResourceId(((SyncMemberInner)this.innerModel()).id());
    }

    @Override
    public SyncMemberDbType databaseType() {
        return ((SyncMemberInner)this.innerModel()).databaseType();
    }

    @Override
    public String syncAgentId() {
        return ((SyncMemberInner)this.innerModel()).syncAgentId();
    }

    @Override
    public String sqlServerDatabaseId() {
        return ((SyncMemberInner)this.innerModel()).sqlServerDatabaseId().toString();
    }

    @Override
    public String memberServerName() {
        return ((SyncMemberInner)this.innerModel()).serverName();
    }

    @Override
    public String memberDatabaseName() {
        return ((SyncMemberInner)this.innerModel()).databaseName();
    }

    @Override
    public String username() {
        return ((SyncMemberInner)this.innerModel()).username();
    }

    @Override
    public SyncDirection syncDirection() {
        return ((SyncMemberInner)this.innerModel()).syncDirection();
    }

    @Override
    public SyncMemberState syncState() {
        return ((SyncMemberInner)this.innerModel()).syncState();
    }

    @Override
    public Mono<SqlSyncMember> createResourceAsync() {
        SqlSyncMemberImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncMembers().createOrUpdateAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.sqlSyncGroupName, this.name(), (SyncMemberInner)this.innerModel()).map(syncMemberInner -> {
            self.setInner(syncMemberInner);
            return self;
        });
    }

    @Override
    public Mono<SqlSyncMember> updateResourceAsync() {
        return this.createResourceAsync();
    }

    @Override
    public Mono<Void> deleteResourceAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncMembers().deleteAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.sqlSyncGroupName, this.name());
    }

    @Override
    protected Mono<SyncMemberInner> getInnerAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncMembers().getAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.sqlSyncGroupName, this.name());
    }

    @Override
    public void delete() {
        ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncMembers().delete(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.sqlSyncGroupName, this.name());
    }

    @Override
    public Mono<Void> deleteAsync() {
        return this.deleteResourceAsync();
    }

    @Override
    public SqlSyncMember.Update update() {
        this.setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeUpdated);
        return this;
    }

    @Override
    public PagedIterable<SqlSyncFullSchemaProperty> listMemberSchemas() {
        return PagedConverter.mapPage(((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncMembers().listMemberSchemas(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.sqlSyncGroupName, this.name()), inner -> new SqlSyncFullSchemaPropertyImpl((SyncFullSchemaPropertiesInner)inner));
    }

    @Override
    public PagedFlux<SqlSyncFullSchemaProperty> listMemberSchemasAsync() {
        return PagedConverter.mapPage(((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncMembers().listMemberSchemasAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.sqlSyncGroupName, this.name()), syncFullSchemaPropertiesInner -> new SqlSyncFullSchemaPropertyImpl((SyncFullSchemaPropertiesInner)syncFullSchemaPropertiesInner));
    }

    @Override
    public void refreshMemberSchema() {
        ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncMembers().refreshMemberSchema(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.sqlSyncGroupName, this.name());
    }

    @Override
    public Mono<Void> refreshMemberSchemaAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncMembers().refreshMemberSchemaAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.sqlSyncGroupName, this.name());
    }

    @Override
    public SqlSyncMemberImpl withExistingSqlServer(String resourceGroupName, String sqlServerName) {
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        return this;
    }

    @Override
    public SqlSyncMemberImpl withExistingSyncGroup(SqlSyncGroup sqlSyncGroup) {
        this.resourceGroupName = sqlSyncGroup.resourceGroupName();
        this.sqlServerName = sqlSyncGroup.sqlServerName();
        this.sqlDatabaseName = sqlSyncGroup.sqlDatabaseName();
        this.sqlSyncGroupName = sqlSyncGroup.name();
        return this;
    }

    @Override
    public SqlSyncMemberImpl withExistingDatabaseName(String databaseName) {
        this.sqlDatabaseName = databaseName;
        return this;
    }

    @Override
    public SqlSyncMemberImpl withMemberUserName(String userName) {
        ((SyncMemberInner)this.innerModel()).withUsername(userName);
        return this;
    }

    @Override
    public SqlSyncMemberImpl withExistingSyncGroupName(String syncGroupName) {
        this.sqlSyncGroupName = syncGroupName;
        return this;
    }

    @Override
    public SqlSyncMemberImpl withMemberPassword(String password) {
        ((SyncMemberInner)this.innerModel()).withPassword(password);
        return this;
    }

    @Override
    public SqlSyncMemberImpl withMemberSqlServerName(String sqlServerName) {
        ((SyncMemberInner)this.innerModel()).withServerName(sqlServerName);
        return this;
    }

    @Override
    public SqlSyncMemberImpl withMemberSqlDatabase(SqlDatabase sqlDatabase) {
        ((SyncMemberInner)this.innerModel()).withServerName(sqlDatabase.sqlServerName());
        ((SyncMemberInner)this.innerModel()).withDatabaseName(sqlDatabase.name());
        return this;
    }

    @Override
    public SqlSyncMemberImpl withMemberDatabaseType(SyncMemberDbType databaseType) {
        ((SyncMemberInner)this.innerModel()).withDatabaseType(databaseType);
        return this;
    }

    @Override
    public SqlSyncMemberImpl withDatabaseType(SyncDirection syncDirection) {
        ((SyncMemberInner)this.innerModel()).withSyncDirection(syncDirection);
        return this;
    }

    @Override
    public SqlSyncMemberImpl withMemberSqlDatabaseName(String sqlDatabaseName) {
        ((SyncMemberInner)this.innerModel()).withDatabaseName(sqlDatabaseName);
        return this;
    }
}

