/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.ServerProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ResourceIdentity;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ServerExternalAdministrator;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ServerNetworkAccessFlag;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ServerPrivateEndpointConnection;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ServerWorkspaceFeature;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class ServerUpdate
implements JsonSerializable<ServerUpdate> {
    private ResourceIdentity identity;
    private ServerProperties innerProperties;
    private Map<String, String> tags;

    public ResourceIdentity identity() {
        return this.identity;
    }

    public ServerUpdate withIdentity(ResourceIdentity identity) {
        this.identity = identity;
        return this;
    }

    private ServerProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ServerUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String administratorLogin() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorLogin();
    }

    public ServerUpdate withAdministratorLogin(String administratorLogin) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withAdministratorLogin(administratorLogin);
        return this;
    }

    public String administratorLoginPassword() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorLoginPassword();
    }

    public ServerUpdate withAdministratorLoginPassword(String administratorLoginPassword) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withAdministratorLoginPassword(administratorLoginPassword);
        return this;
    }

    public String version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    public ServerUpdate withVersion(String version) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withVersion(version);
        return this;
    }

    public String state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public String fullyQualifiedDomainName() {
        return this.innerProperties() == null ? null : this.innerProperties().fullyQualifiedDomainName();
    }

    public List<ServerPrivateEndpointConnection> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    public String minimalTlsVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().minimalTlsVersion();
    }

    public ServerUpdate withMinimalTlsVersion(String minimalTlsVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withMinimalTlsVersion(minimalTlsVersion);
        return this;
    }

    public ServerNetworkAccessFlag publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public ServerUpdate withPublicNetworkAccess(ServerNetworkAccessFlag publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public ServerWorkspaceFeature workspaceFeature() {
        return this.innerProperties() == null ? null : this.innerProperties().workspaceFeature();
    }

    public String primaryUserAssignedIdentityId() {
        return this.innerProperties() == null ? null : this.innerProperties().primaryUserAssignedIdentityId();
    }

    public ServerUpdate withPrimaryUserAssignedIdentityId(String primaryUserAssignedIdentityId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withPrimaryUserAssignedIdentityId(primaryUserAssignedIdentityId);
        return this;
    }

    public UUID federatedClientId() {
        return this.innerProperties() == null ? null : this.innerProperties().federatedClientId();
    }

    public ServerUpdate withFederatedClientId(UUID federatedClientId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withFederatedClientId(federatedClientId);
        return this;
    }

    public String keyId() {
        return this.innerProperties() == null ? null : this.innerProperties().keyId();
    }

    public ServerUpdate withKeyId(String keyId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withKeyId(keyId);
        return this;
    }

    public ServerExternalAdministrator administrators() {
        return this.innerProperties() == null ? null : this.innerProperties().administrators();
    }

    public ServerUpdate withAdministrators(ServerExternalAdministrator administrators) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withAdministrators(administrators);
        return this;
    }

    public ServerNetworkAccessFlag restrictOutboundNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().restrictOutboundNetworkAccess();
    }

    public ServerUpdate withRestrictOutboundNetworkAccess(ServerNetworkAccessFlag restrictOutboundNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withRestrictOutboundNetworkAccess(restrictOutboundNetworkAccess);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("identity", this.identity);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static ServerUpdate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServerUpdate deserializedServerUpdate = new ServerUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("identity".equals(fieldName)) {
                    deserializedServerUpdate.identity = ResourceIdentity.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedServerUpdate.innerProperties = ServerProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedServerUpdate.tags = tags;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerUpdate;
        });
    }
}

