/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.ObjectReplicationPolicyPropertiesMetrics;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.ObjectReplicationPolicyRule;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class ObjectReplicationPolicyProperties
implements JsonSerializable<ObjectReplicationPolicyProperties> {
    private String policyId;
    private OffsetDateTime enabledTime;
    private String sourceAccount;
    private String destinationAccount;
    private List<ObjectReplicationPolicyRule> rules;
    private ObjectReplicationPolicyPropertiesMetrics metrics;
    private static final ClientLogger LOGGER = new ClientLogger(ObjectReplicationPolicyProperties.class);

    public String policyId() {
        return this.policyId;
    }

    public OffsetDateTime enabledTime() {
        return this.enabledTime;
    }

    public String sourceAccount() {
        return this.sourceAccount;
    }

    public ObjectReplicationPolicyProperties withSourceAccount(String sourceAccount) {
        this.sourceAccount = sourceAccount;
        return this;
    }

    public String destinationAccount() {
        return this.destinationAccount;
    }

    public ObjectReplicationPolicyProperties withDestinationAccount(String destinationAccount) {
        this.destinationAccount = destinationAccount;
        return this;
    }

    public List<ObjectReplicationPolicyRule> rules() {
        return this.rules;
    }

    public ObjectReplicationPolicyProperties withRules(List<ObjectReplicationPolicyRule> rules) {
        this.rules = rules;
        return this;
    }

    public ObjectReplicationPolicyPropertiesMetrics metrics() {
        return this.metrics;
    }

    public ObjectReplicationPolicyProperties withMetrics(ObjectReplicationPolicyPropertiesMetrics metrics) {
        this.metrics = metrics;
        return this;
    }

    public void validate() {
        if (this.sourceAccount() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property sourceAccount in model ObjectReplicationPolicyProperties"));
        }
        if (this.destinationAccount() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property destinationAccount in model ObjectReplicationPolicyProperties"));
        }
        if (this.rules() != null) {
            this.rules().forEach(e -> e.validate());
        }
        if (this.metrics() != null) {
            this.metrics().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceAccount", this.sourceAccount);
        jsonWriter.writeStringField("destinationAccount", this.destinationAccount);
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeJsonField("metrics", this.metrics);
        return jsonWriter.writeEndObject();
    }

    public static ObjectReplicationPolicyProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ObjectReplicationPolicyProperties deserializedObjectReplicationPolicyProperties = new ObjectReplicationPolicyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceAccount".equals(fieldName)) {
                    deserializedObjectReplicationPolicyProperties.sourceAccount = reader.getString();
                    continue;
                }
                if ("destinationAccount".equals(fieldName)) {
                    deserializedObjectReplicationPolicyProperties.destinationAccount = reader.getString();
                    continue;
                }
                if ("policyId".equals(fieldName)) {
                    deserializedObjectReplicationPolicyProperties.policyId = reader.getString();
                    continue;
                }
                if ("enabledTime".equals(fieldName)) {
                    deserializedObjectReplicationPolicyProperties.enabledTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("rules".equals(fieldName)) {
                    List<ObjectReplicationPolicyRule> rules = reader.readArray(reader1 -> ObjectReplicationPolicyRule.fromJson(reader1));
                    deserializedObjectReplicationPolicyProperties.rules = rules;
                    continue;
                }
                if ("metrics".equals(fieldName)) {
                    deserializedObjectReplicationPolicyProperties.metrics = ObjectReplicationPolicyPropertiesMetrics.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedObjectReplicationPolicyProperties;
        });
    }
}

