/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class AccessPolicy
implements JsonSerializable<AccessPolicy> {
    private OffsetDateTime startTime;
    private OffsetDateTime expiryTime;
    private String permission;

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public AccessPolicy withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime expiryTime() {
        return this.expiryTime;
    }

    public AccessPolicy withExpiryTime(OffsetDateTime expiryTime) {
        this.expiryTime = expiryTime;
        return this;
    }

    public String permission() {
        return this.permission;
    }

    public AccessPolicy withPermission(String permission) {
        this.permission = permission;
        return this;
    }

    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("expiryTime", this.expiryTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiryTime));
        jsonWriter.writeStringField("permission", this.permission);
        return jsonWriter.writeEndObject();
    }

    public static AccessPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AccessPolicy deserializedAccessPolicy = new AccessPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startTime".equals(fieldName)) {
                    deserializedAccessPolicy.startTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("expiryTime".equals(fieldName)) {
                    deserializedAccessPolicy.expiryTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("permission".equals(fieldName)) {
                    deserializedAccessPolicy.permission = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAccessPolicy;
        });
    }
}

