/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.HttpProtocol;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.Permissions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.SignedResource;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class ServiceSasParameters
implements JsonSerializable<ServiceSasParameters> {
    private String canonicalizedResource;
    private SignedResource resource;
    private Permissions permissions;
    private String ipAddressOrRange;
    private HttpProtocol protocols;
    private OffsetDateTime sharedAccessStartTime;
    private OffsetDateTime sharedAccessExpiryTime;
    private String identifier;
    private String partitionKeyStart;
    private String partitionKeyEnd;
    private String rowKeyStart;
    private String rowKeyEnd;
    private String keyToSign;
    private String cacheControl;
    private String contentDisposition;
    private String contentEncoding;
    private String contentLanguage;
    private String contentType;
    private static final ClientLogger LOGGER = new ClientLogger(ServiceSasParameters.class);

    public String canonicalizedResource() {
        return this.canonicalizedResource;
    }

    public ServiceSasParameters withCanonicalizedResource(String canonicalizedResource) {
        this.canonicalizedResource = canonicalizedResource;
        return this;
    }

    public SignedResource resource() {
        return this.resource;
    }

    public ServiceSasParameters withResource(SignedResource resource) {
        this.resource = resource;
        return this;
    }

    public Permissions permissions() {
        return this.permissions;
    }

    public ServiceSasParameters withPermissions(Permissions permissions) {
        this.permissions = permissions;
        return this;
    }

    public String ipAddressOrRange() {
        return this.ipAddressOrRange;
    }

    public ServiceSasParameters withIpAddressOrRange(String ipAddressOrRange) {
        this.ipAddressOrRange = ipAddressOrRange;
        return this;
    }

    public HttpProtocol protocols() {
        return this.protocols;
    }

    public ServiceSasParameters withProtocols(HttpProtocol protocols) {
        this.protocols = protocols;
        return this;
    }

    public OffsetDateTime sharedAccessStartTime() {
        return this.sharedAccessStartTime;
    }

    public ServiceSasParameters withSharedAccessStartTime(OffsetDateTime sharedAccessStartTime) {
        this.sharedAccessStartTime = sharedAccessStartTime;
        return this;
    }

    public OffsetDateTime sharedAccessExpiryTime() {
        return this.sharedAccessExpiryTime;
    }

    public ServiceSasParameters withSharedAccessExpiryTime(OffsetDateTime sharedAccessExpiryTime) {
        this.sharedAccessExpiryTime = sharedAccessExpiryTime;
        return this;
    }

    public String identifier() {
        return this.identifier;
    }

    public ServiceSasParameters withIdentifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public String partitionKeyStart() {
        return this.partitionKeyStart;
    }

    public ServiceSasParameters withPartitionKeyStart(String partitionKeyStart) {
        this.partitionKeyStart = partitionKeyStart;
        return this;
    }

    public String partitionKeyEnd() {
        return this.partitionKeyEnd;
    }

    public ServiceSasParameters withPartitionKeyEnd(String partitionKeyEnd) {
        this.partitionKeyEnd = partitionKeyEnd;
        return this;
    }

    public String rowKeyStart() {
        return this.rowKeyStart;
    }

    public ServiceSasParameters withRowKeyStart(String rowKeyStart) {
        this.rowKeyStart = rowKeyStart;
        return this;
    }

    public String rowKeyEnd() {
        return this.rowKeyEnd;
    }

    public ServiceSasParameters withRowKeyEnd(String rowKeyEnd) {
        this.rowKeyEnd = rowKeyEnd;
        return this;
    }

    public String keyToSign() {
        return this.keyToSign;
    }

    public ServiceSasParameters withKeyToSign(String keyToSign) {
        this.keyToSign = keyToSign;
        return this;
    }

    public String cacheControl() {
        return this.cacheControl;
    }

    public ServiceSasParameters withCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public String contentDisposition() {
        return this.contentDisposition;
    }

    public ServiceSasParameters withContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public String contentEncoding() {
        return this.contentEncoding;
    }

    public ServiceSasParameters withContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public String contentLanguage() {
        return this.contentLanguage;
    }

    public ServiceSasParameters withContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public String contentType() {
        return this.contentType;
    }

    public ServiceSasParameters withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public void validate() {
        if (this.canonicalizedResource() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property canonicalizedResource in model ServiceSasParameters"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("canonicalizedResource", this.canonicalizedResource);
        jsonWriter.writeStringField("signedResource", this.resource == null ? null : this.resource.toString());
        jsonWriter.writeStringField("signedPermission", this.permissions == null ? null : this.permissions.toString());
        jsonWriter.writeStringField("signedIp", this.ipAddressOrRange);
        jsonWriter.writeStringField("signedProtocol", this.protocols == null ? null : this.protocols.toString());
        jsonWriter.writeStringField("signedStart", this.sharedAccessStartTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.sharedAccessStartTime));
        jsonWriter.writeStringField("signedExpiry", this.sharedAccessExpiryTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.sharedAccessExpiryTime));
        jsonWriter.writeStringField("signedIdentifier", this.identifier);
        jsonWriter.writeStringField("startPk", this.partitionKeyStart);
        jsonWriter.writeStringField("endPk", this.partitionKeyEnd);
        jsonWriter.writeStringField("startRk", this.rowKeyStart);
        jsonWriter.writeStringField("endRk", this.rowKeyEnd);
        jsonWriter.writeStringField("keyToSign", this.keyToSign);
        jsonWriter.writeStringField("rscc", this.cacheControl);
        jsonWriter.writeStringField("rscd", this.contentDisposition);
        jsonWriter.writeStringField("rsce", this.contentEncoding);
        jsonWriter.writeStringField("rscl", this.contentLanguage);
        jsonWriter.writeStringField("rsct", this.contentType);
        return jsonWriter.writeEndObject();
    }

    public static ServiceSasParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServiceSasParameters deserializedServiceSasParameters = new ServiceSasParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("canonicalizedResource".equals(fieldName)) {
                    deserializedServiceSasParameters.canonicalizedResource = reader.getString();
                    continue;
                }
                if ("signedResource".equals(fieldName)) {
                    deserializedServiceSasParameters.resource = SignedResource.fromString(reader.getString());
                    continue;
                }
                if ("signedPermission".equals(fieldName)) {
                    deserializedServiceSasParameters.permissions = Permissions.fromString(reader.getString());
                    continue;
                }
                if ("signedIp".equals(fieldName)) {
                    deserializedServiceSasParameters.ipAddressOrRange = reader.getString();
                    continue;
                }
                if ("signedProtocol".equals(fieldName)) {
                    deserializedServiceSasParameters.protocols = HttpProtocol.fromString(reader.getString());
                    continue;
                }
                if ("signedStart".equals(fieldName)) {
                    deserializedServiceSasParameters.sharedAccessStartTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("signedExpiry".equals(fieldName)) {
                    deserializedServiceSasParameters.sharedAccessExpiryTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("signedIdentifier".equals(fieldName)) {
                    deserializedServiceSasParameters.identifier = reader.getString();
                    continue;
                }
                if ("startPk".equals(fieldName)) {
                    deserializedServiceSasParameters.partitionKeyStart = reader.getString();
                    continue;
                }
                if ("endPk".equals(fieldName)) {
                    deserializedServiceSasParameters.partitionKeyEnd = reader.getString();
                    continue;
                }
                if ("startRk".equals(fieldName)) {
                    deserializedServiceSasParameters.rowKeyStart = reader.getString();
                    continue;
                }
                if ("endRk".equals(fieldName)) {
                    deserializedServiceSasParameters.rowKeyEnd = reader.getString();
                    continue;
                }
                if ("keyToSign".equals(fieldName)) {
                    deserializedServiceSasParameters.keyToSign = reader.getString();
                    continue;
                }
                if ("rscc".equals(fieldName)) {
                    deserializedServiceSasParameters.cacheControl = reader.getString();
                    continue;
                }
                if ("rscd".equals(fieldName)) {
                    deserializedServiceSasParameters.contentDisposition = reader.getString();
                    continue;
                }
                if ("rsce".equals(fieldName)) {
                    deserializedServiceSasParameters.contentEncoding = reader.getString();
                    continue;
                }
                if ("rscl".equals(fieldName)) {
                    deserializedServiceSasParameters.contentLanguage = reader.getString();
                    continue;
                }
                if ("rsct".equals(fieldName)) {
                    deserializedServiceSasParameters.contentType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServiceSasParameters;
        });
    }
}

